/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.updater;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.repository.AdbWrapper;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.LocalSdkParser;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.archives.ArchiveInstaller;
import com.android.sdklib.internal.repository.packages.AddonPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PlatformToolPackage;
import com.android.sdklib.internal.repository.packages.ToolPackage;
import com.android.sdklib.internal.repository.sources.SdkRepoSource;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSourceCategory;
import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.internal.repository.updater.ArchiveInfo;
import com.android.sdklib.internal.repository.updater.IUpdaterData;
import com.android.sdklib.internal.repository.updater.PackageLoader;
import com.android.sdklib.internal.repository.updater.SdkUpdaterLogic;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.repository.ISdkChangeListener;
import com.android.sdklib.repository.SdkAddonConstants;
import com.android.sdklib.repository.SdkRepoConstants;
import com.android.sdklib.util.LineUtil;
import com.android.utils.ILogger;
import com.android.utils.SparseIntArray;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdaterData
implements IUpdaterData {
    public static final int NO_TOOLS_MSG = 0;
    public static final int TOOLS_MSG_UPDATED_FROM_ADT = 1;
    public static final int TOOLS_MSG_UPDATED_FROM_SDKMAN = 2;
    private String mOsSdkRoot;
    private final LocalSdkParser mLocalSdkParser = new LocalSdkParser();
    private final SdkSources mSources = new SdkSources();
    private final SettingsController mSettingsController;
    private final ArrayList<ISdkChangeListener> mListeners = new ArrayList();
    private final ILogger mSdkLog;
    private ITaskFactory mTaskFactory;
    private SdkManager mSdkManager;
    private AvdManager mAvdManager;
    private PackageLoader mPackageLoader;
    private DownloadCache mDownloadCache;
    private AndroidLocation.AndroidLocationException mAvdManagerInitError;

    public UpdaterData(String osSdkRoot, ILogger sdkLog) {
        this.mOsSdkRoot = osSdkRoot;
        this.mSdkLog = sdkLog;
        this.mSettingsController = this.initSettingsController();
        this.initSdk();
    }

    public String getOsSdkRoot() {
        return this.mOsSdkRoot;
    }

    @Override
    public DownloadCache getDownloadCache() {
        if (this.mDownloadCache == null) {
            this.mDownloadCache = new DownloadCache(this.getSettingsController().getSettings().getUseDownloadCache() ? DownloadCache.Strategy.FRESH_CACHE : DownloadCache.Strategy.DIRECT);
        }
        return this.mDownloadCache;
    }

    public void setTaskFactory(ITaskFactory taskFactory) {
        this.mTaskFactory = taskFactory;
    }

    @Override
    public ITaskFactory getTaskFactory() {
        return this.mTaskFactory;
    }

    public SdkSources getSources() {
        return this.mSources;
    }

    public LocalSdkParser getLocalSdkParser() {
        return this.mLocalSdkParser;
    }

    @Override
    public ILogger getSdkLog() {
        return this.mSdkLog;
    }

    @Override
    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    @Override
    public AvdManager getAvdManager() {
        return this.mAvdManager;
    }

    @Override
    public SettingsController getSettingsController() {
        return this.mSettingsController;
    }

    public void addListeners(ISdkChangeListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(ISdkChangeListener listener) {
        this.mListeners.remove(listener);
    }

    public PackageLoader getPackageLoader() {
        if (this.mPackageLoader == null) {
            this.mPackageLoader = new PackageLoader(this);
        }
        return this.mPackageLoader;
    }

    public boolean checkIfInitFailed() {
        if (this.mAvdManagerInitError != null) {
            String example = SdkConstants.currentPlatform() == 2 ? "%USERPROFILE%" : "~";
            String error = String.format("The AVD manager normally uses the user's profile directory to store AVD files. However it failed to find the default profile directory. \nTo fix this, please set the environment variable ANDROID_SDK_HOME to a valid path such as \"%s\".", example);
            this.displayInitError(error);
            return true;
        }
        return false;
    }

    protected void displayInitError(String error) {
        this.mSdkLog.error(null, "%s", new Object[]{error});
    }

    protected void runOnUiThread(@NonNull Runnable r) {
        r.run();
    }

    protected void initSdk() {
        this.setSdkManager(SdkManager.createManager(this.mOsSdkRoot, this.mSdkLog));
        try {
            this.mAvdManager = null;
            this.mAvdManager = AvdManager.getInstance(this.mSdkManager.getLocalSdk(), this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.mSdkLog.error((Throwable)e, "Unable to read AVDs: " + e.getMessage(), new Object[0]);
            this.mAvdManagerInitError = e;
        }
        this.broadcastOnSdkReload();
    }

    protected SettingsController initSettingsController() {
        SettingsController settingsController = new SettingsController(this.mSdkLog);
        settingsController.registerOnChangedListener(new SettingsController.OnChangedListener(){

            @Override
            public void onSettingsChanged(SettingsController controller, SettingsController.Settings oldSettings) {
                if (UpdaterData.this.mDownloadCache != null) {
                    if (controller.getSettings().getUseDownloadCache() && UpdaterData.this.mDownloadCache.getStrategy() != DownloadCache.Strategy.FRESH_CACHE) {
                        UpdaterData.this.mDownloadCache = null;
                    } else if (!controller.getSettings().getUseDownloadCache() && UpdaterData.this.mDownloadCache.getStrategy() != DownloadCache.Strategy.DIRECT) {
                        UpdaterData.this.mDownloadCache = null;
                    }
                }
            }
        });
        return settingsController;
    }

    protected void setSdkManager(SdkManager sdkManager) {
        this.mSdkManager = sdkManager;
    }

    public void reloadSdk() {
        this.mSdkManager.reloadSdk(this.mSdkLog);
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                // empty catch block
            }
        }
        this.mLocalSdkParser.clearPackages();
        this.broadcastOnSdkReload();
    }

    public void reloadAvds() {
        if (this.mAvdManager != null) {
            try {
                this.mAvdManager.reloadAvds(this.mSdkLog);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                this.mSdkLog.error((Throwable)e, null, new Object[0]);
            }
        }
    }

    public void setupDefaultSources() {
        SdkSources sources = this.getSources();
        String baseUrl = System.getenv("SDK_TEST_BASE_URL");
        if (baseUrl == null || baseUrl.length() <= 0 || !baseUrl.endsWith("/")) {
            baseUrl = "https://dl-ssl.google.com/android/repository/";
        }
        sources.add(SdkSourceCategory.ANDROID_REPO, new SdkRepoSource(baseUrl, SdkSourceCategory.ANDROID_REPO.getUiName()));
        sources.loadUserAddons(this.getSdkLog());
    }

    public Package[] getInstalledPackages(ITaskMonitor monitor) {
        LocalSdkParser parser = this.getLocalSdkParser();
        Package[] packages = parser.getPackages();
        if (packages == null) {
            packages = parser.parseSdk(this.getOsSdkRoot(), this.getSdkManager(), monitor);
        }
        return packages;
    }

    protected List<Archive> installArchives(final List<ArchiveInfo> archives, final int flags) {
        if (this.mTaskFactory == null) {
            throw new IllegalArgumentException("Task Factory is null");
        }
        final ArrayList<Archive> newlyInstalledArchives = new ArrayList<Archive>();
        final boolean forceHttp = this.getSettingsController().getSettings().getForceHttp();
        Collections.sort(archives, new InstallOrderComparator());
        this.mTaskFactory.start("Installing Archives", new ITask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(ITaskMonitor monitor) {
                int progressPerArchive = 200;
                monitor.setProgressMax(1 + archives.size() * 200);
                monitor.setDescription("Preparing to install archives", new Object[0]);
                boolean installedAddon = false;
                boolean installedTools = false;
                boolean installedPlatformTools = false;
                boolean preInstallHookInvoked = false;
                HashSet<Archive> installedArchives = new HashSet<Archive>();
                for (Package p : UpdaterData.this.getInstalledPackages(monitor.createSubMonitor(1))) {
                    for (Archive a : p.getArchives()) {
                        installedArchives.add(a);
                    }
                }
                int numInstalled = 0;
                block12: for (ArchiveInfo ai : archives) {
                    Archive archive = ai.getNewArchive();
                    if (archive == null) continue;
                    int nextProgress = monitor.getProgress() + 200;
                    try {
                        ArchiveInstaller installer;
                        if (monitor.isCancelRequested()) break;
                        ArchiveInfo[] adeps = ai.getDependsOn();
                        if (adeps != null) {
                            for (ArchiveInfo adep : adeps) {
                                Archive na = adep.getNewArchive();
                                if (na == null) {
                                    monitor.log("Skipping '%1$s'; it depends on a missing package.", archive.getParentPackage().getShortDescription());
                                    continue block12;
                                }
                                if (installedArchives.contains(na)) continue;
                                monitor.logError("Skipping '%1$s'; it depends on '%2$s' which was not installed.", archive.getParentPackage().getShortDescription(), adep.getShortDescription());
                                continue block12;
                            }
                        }
                        if (!preInstallHookInvoked) {
                            preInstallHookInvoked = true;
                            UpdaterData.this.broadcastPreInstallHook();
                        }
                        if (!(installer = UpdaterData.this.createArchiveInstaler()).install(ai, UpdaterData.this.mOsSdkRoot, forceHttp, UpdaterData.this.mSdkManager, UpdaterData.this.getDownloadCache(), monitor)) continue;
                        newlyInstalledArchives.add(archive);
                        installedArchives.add(archive);
                        ++numInstalled;
                        installedArchives.remove(ai.getReplaced());
                        if (archive.getParentPackage() instanceof AddonPackage) {
                            installedAddon = true;
                            continue;
                        }
                        if (archive.getParentPackage() instanceof ToolPackage) {
                            installedTools = true;
                            continue;
                        }
                        if (!(archive.getParentPackage() instanceof PlatformToolPackage)) continue;
                        installedPlatformTools = true;
                    }
                    catch (Throwable t) {
                        String msg = t.getMessage();
                        if (msg != null) {
                            msg = String.format("Unexpected Error installing '%1$s': %2$s: %3$s", archive.getParentPackage().getShortDescription(), t.getClass().getCanonicalName(), msg);
                        } else {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            t.printStackTrace(new PrintStream(baos));
                            msg = String.format("Unexpected Error installing '%1$s'\n%2$s", archive.getParentPackage().getShortDescription(), baos.toString());
                        }
                        monitor.log("%1$s", msg);
                        UpdaterData.this.mSdkLog.error(t, "%1$s", new Object[]{msg});
                    }
                    finally {
                        monitor.incProgress(nextProgress - monitor.getProgress());
                    }
                }
                if (installedAddon) {
                    try {
                        UpdaterData.this.mSdkManager.updateAdb();
                        monitor.log("Updated ADB to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                    catch (Exception e) {
                        UpdaterData.this.mSdkLog.error((Throwable)e, "Update ADB failed", new Object[0]);
                        monitor.logError("failed to update adb to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                }
                if (preInstallHookInvoked) {
                    UpdaterData.this.broadcastPostInstallHook();
                }
                if (installedAddon || installedPlatformTools) {
                    UpdaterData.this.askForAdbRestart(monitor);
                }
                if (installedTools) {
                    UpdaterData.this.notifyToolsNeedsToBeRestarted(flags);
                }
                if (numInstalled == 0) {
                    monitor.setDescription("Done. Nothing was installed.", new Object[0]);
                } else {
                    monitor.setDescription("Done. %1$d %2$s installed.", numInstalled, numInstalled == 1 ? "package" : "packages");
                    UpdaterData.this.reloadSdk();
                }
            }
        });
        return newlyInstalledArchives;
    }

    protected void askForAdbRestart(ITaskMonitor monitor) {
        if (!this.getSettingsController().getSettings().getAskBeforeAdbRestart()) {
            AdbWrapper adb = new AdbWrapper(this.getOsSdkRoot(), monitor);
            adb.stopAdb();
            adb.startAdb();
        }
    }

    protected void notifyToolsNeedsToBeRestarted(int flags) {
        String msg = null;
        if ((flags & 1) != 0) {
            msg = "The Android SDK and AVD Manager that you are currently using has been updated. Please also run Eclipse > Help > Check for Updates to see if the Android plug-in needs to be updated.";
        } else if ((flags & 2) != 0) {
            msg = "The Android SDK and AVD Manager that you are currently using has been updated. It is recommended that you now close the manager window and re-open it. If you use Eclipse, please run Help > Check for Updates to see if the Android plug-in needs to be updated.";
        }
        this.mSdkLog.info("%s", new Object[]{msg});
    }

    private List<ArchiveInfo> getRemoteArchives_NoGUI(boolean includeAll) {
        List<ArchiveInfo> archives;
        this.refreshSources(true);
        this.getPackageLoader().loadRemoteAddonsList(new NullTaskMonitor(this.getSdkLog()));
        SdkUpdaterLogic ul = new SdkUpdaterLogic(this);
        if (includeAll) {
            archives = ul.getAllRemoteArchives(this.getSources(), this.getLocalSdkParser().getPackages(), includeAll);
        } else {
            archives = ul.computeUpdates(null, this.getSources(), this.getLocalSdkParser().getPackages(), includeAll);
            ul.addNewPlatforms(archives, this.getSources(), this.getLocalSdkParser().getPackages(), includeAll);
        }
        Collections.sort(archives);
        return archives;
    }

    public void listRemotePackages_NoGUI(boolean includeAll, boolean extendedOutput) {
        List<ArchiveInfo> archives = this.getRemoteArchives_NoGUI(includeAll);
        this.mSdkLog.info("Packages available for installation or update: %1$d\n", new Object[]{archives.size()});
        int index = 1;
        for (ArchiveInfo ai : archives) {
            Package p;
            Archive a = ai.getNewArchive();
            if (a == null || (p = a.getParentPackage()) == null) continue;
            if (extendedOutput) {
                this.mSdkLog.info("----------\n", new Object[0]);
                this.mSdkLog.info("id: %1$d or \"%2$s\"\n", new Object[]{index, p.installId()});
                this.mSdkLog.info("     Type: %1$s\n", new Object[]{p.getClass().getSimpleName().replaceAll("Package", "")});
                String desc = LineUtil.reformatLine("     Desc: %s\n", p.getLongDescription());
                this.mSdkLog.info("%s", new Object[]{desc});
            } else {
                this.mSdkLog.info("%1$ 4d- %2$s\n", new Object[]{index, p.getShortDescription()});
            }
            ++index;
        }
    }

    public List<Archive> updateOrInstallAll_WithGUI(Collection<Archive> selectedArchives, boolean includeObsoletes, int flags) {
        SdkUpdaterLogic ul = new SdkUpdaterLogic(this);
        List<ArchiveInfo> archives = ul.computeUpdates(selectedArchives, this.getSources(), this.getLocalSdkParser().getPackages(), includeObsoletes);
        if (selectedArchives == null) {
            this.getPackageLoader().loadRemoteAddonsList(new NullTaskMonitor(this.getSdkLog()));
            ul.addNewPlatforms(archives, this.getSources(), this.getLocalSdkParser().getPackages(), includeObsoletes);
        }
        Collections.sort(archives);
        if (archives.size() > 0) {
            return this.installArchives(archives, flags);
        }
        return null;
    }

    public List<Archive> updateOrInstallAll_NoGUI(Collection<String> pkgFilter, boolean includeAll, boolean dryMode, String acceptLicense) {
        List<ArchiveInfo> archives = this.getRemoteArchives_NoGUI(includeAll);
        if (pkgFilter != null && pkgFilter.size() > 0 && archives != null && archives.size() > 0) {
            HashMap<String, Class<? extends Package>> pkgMap = new HashMap<String, Class<? extends Package>>();
            this.mapFilterToPackageClass(pkgMap, SdkRepoConstants.NODES);
            this.mapFilterToPackageClass(pkgMap, SdkAddonConstants.NODES);
            HashMap<String, Package> installIdMap = new HashMap<String, Package>();
            for (ArchiveInfo ai : archives) {
                String id;
                Package p;
                Archive a = ai.getNewArchive();
                if (a == null || (p = a.getParentPackage()) == null || (id = p.installId()) == null || id.length() <= 0 || installIdMap.containsKey(id)) continue;
                installIdMap.put(id, p);
            }
            HashSet<Class<? extends Package>> userFilteredClasses = new HashSet<Class<? extends Package>>();
            SparseIntArray userFilteredIndices = new SparseIntArray();
            HashSet<String> userFilteredInstallIds = new HashSet<String>();
            for (String type : pkgFilter) {
                if (installIdMap.containsKey(type)) {
                    userFilteredInstallIds.add(type);
                    continue;
                }
                if (type.replaceAll("[0-9]+", "").length() == 0) {
                    int index = Integer.parseInt(type);
                    userFilteredIndices.put(index, index);
                    continue;
                }
                if (pkgMap.containsKey(type)) {
                    userFilteredClasses.add(pkgMap.get(type));
                    continue;
                }
                this.mSdkLog.error(null, "Ignoring unknown package filter '%1$s'", new Object[]{type});
            }
            pkgMap = null;
            installIdMap = null;
            int index = 1;
            Iterator<ArchiveInfo> it = archives.iterator();
            while (it.hasNext()) {
                Package p;
                boolean keep = false;
                ArchiveInfo ai = it.next();
                Archive a = ai.getNewArchive();
                if (a != null && (p = a.getParentPackage()) != null) {
                    if (userFilteredInstallIds.contains(p.installId()) || userFilteredClasses.contains(p.getClass()) || userFilteredIndices.get(index) > 0) {
                        keep = true;
                    }
                    ++index;
                }
                if (keep) continue;
                it.remove();
            }
            if (archives.size() == 0) {
                this.mSdkLog.info(LineUtil.reflowLine("Warning: The package filter removed all packages. There is nothing to install.\nPlease consider trying to update again without a package filter.\n"), new Object[0]);
                return null;
            }
        }
        if (archives != null && archives.size() > 0) {
            if (dryMode) {
                this.mSdkLog.info("Packages selected for install:\n", new Object[0]);
                for (ArchiveInfo ai : archives) {
                    Package p;
                    Archive a = ai.getNewArchive();
                    if (a == null || (p = a.getParentPackage()) == null) continue;
                    this.mSdkLog.info("- %1$s\n", new Object[]{p.getShortDescription()});
                }
                this.mSdkLog.info("\nDry mode is on so nothing is actually being installed.\n", new Object[0]);
            } else if (this.acceptLicense(archives, acceptLicense, 100)) {
                return this.installArchives(archives, 0);
            }
        } else {
            this.mSdkLog.info("There is nothing to install or update.\n", new Object[0]);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    boolean acceptLicense(List<ArchiveInfo> archives, String acceptLicenseIds, int numRetries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Package.License getArchiveInfoLicense(ArchiveInfo ai) {
        Package.License lic;
        Package p;
        Archive a = ai.getNewArchive();
        if (a != null && (p = a.getParentPackage()) != null && (lic = p.getLicense()) != null && lic.getLicenseRef() != null && lic.getLicense().length() > 0 && lic.getLicense() != null && lic.getLicense().length() > 0) {
            return lic;
        }
        return null;
    }

    private String getLicenseId(Package.License lic) {
        return String.format("%1$s-%2$08x", lic.getLicenseRef(), lic.getLicense().hashCode());
    }

    private void mapFilterToPackageClass(HashMap<String, Class<? extends Package>> inOutPkgMap, String[] nodes) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String basePackage = Package.class.getPackage().getName();
        block2: for (String node : nodes) {
            String name = node.substring(0, 1).toUpperCase() + node.substring(1);
            int dash = name.indexOf(45);
            if (dash > 0) {
                name = name.replaceFirst("-", "");
            }
            for (int alternatives = 0; alternatives < 2; ++alternatives) {
                String fqcn = basePackage + '.' + name + "Package";
                try {
                    Class<?> clazz = classLoader.loadClass(fqcn);
                    if (clazz != null) {
                        inOutPkgMap.put(node, clazz);
                        continue;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (alternatives != 0 || dash <= 0) continue block2;
                name = name.substring(0, dash) + name.substring(dash, dash + 1).toUpperCase() + name.substring(dash + 1);
            }
        }
    }

    public void refreshSources(final boolean forceFetching) {
        assert (this.mTaskFactory != null);
        final boolean forceHttp = this.getSettingsController().getSettings().getForceHttp();
        this.mTaskFactory.start("Refresh Sources", new ITask(){

            @Override
            public void run(ITaskMonitor monitor) {
                UpdaterData.this.getPackageLoader().loadRemoteAddonsList(monitor);
                SdkSource[] sources = UpdaterData.this.getSources().getAllSources();
                monitor.setDescription("Refresh Sources", new Object[0]);
                monitor.setProgressMax(monitor.getProgress() + sources.length);
                for (SdkSource source : sources) {
                    if (forceFetching || source.getPackages() != null || source.getFetchError() != null) {
                        source.load(UpdaterData.this.getDownloadCache(), monitor.createSubMonitor(1), forceHttp);
                    }
                    monitor.incProgress(1);
                }
            }
        });
    }

    public void broadcastOnSdkLoaded() {
        if (this.mListeners.size() > 0) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (ISdkChangeListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.onSdkLoaded();
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private void broadcastOnSdkReload() {
        if (this.mListeners.size() > 0) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (ISdkChangeListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.onSdkReload();
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private void broadcastPreInstallHook() {
        if (this.mListeners.size() > 0) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (ISdkChangeListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.preInstallHook();
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private void broadcastPostInstallHook() {
        if (this.mListeners.size() > 0) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (ISdkChangeListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.postInstallHook();
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    protected ArchiveInstaller createArchiveInstaler() {
        return new ArchiveInstaller();
    }

    private static class InstallOrderComparator
    implements Comparator<ArchiveInfo> {
        private final Map<ArchiveInfo, Integer> mOrders = new HashMap<ArchiveInfo, Integer>();

        private InstallOrderComparator() {
        }

        @Override
        public int compare(ArchiveInfo o1, ArchiveInfo o2) {
            int n1 = this.getDependencyOrder(o1);
            int n2 = this.getDependencyOrder(o2);
            return n1 - n2;
        }

        private int getDependencyOrder(ArchiveInfo ai) {
            if (ai == null) {
                return 0;
            }
            Integer cached = this.mOrders.get(ai);
            if (cached != null) {
                return cached;
            }
            ArchiveInfo[] deps = ai.getDependsOn();
            if (deps == null) {
                return 0;
            }
            int n = deps.length;
            for (ArchiveInfo dep : deps) {
                n += this.getDependencyOrder(dep);
            }
            this.mOrders.put(ai, n);
            return n;
        }
    }
}

