/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.ExtraPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import java.io.File;
import java.util.Properties;

public class LocalExtraPkgInfo
extends LocalPkgInfo {
    @NonNull
    private final IPkgDescExtra mDesc;

    public LocalExtraPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps, @NonNull String vendorId, @NonNull String path, @NonNull String[] oldPaths, @NonNull NoPreviewRevision revision) {
        super(localSdk, localDir, sourceProps);
        this.mDesc = PkgDesc.newExtra(vendorId, path, oldPaths, revision);
    }

    @Override
    @NonNull
    public IPkgDesc getDesc() {
        return this.mDesc;
    }

    @NonNull
    public String[] getOldPaths() {
        return this.mDesc.getOldPaths();
    }

    @Override
    @Nullable
    public Package getPackage() {
        Package pkg = super.getPackage();
        if (pkg == null) {
            try {
                pkg = ExtraPackage.create(null, this.getSourceProperties(), this.mDesc.getVendorId(), this.mDesc.getPath(), 0, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), this.getLocalDir().getPath());
                this.setPackage(pkg);
            }
            catch (Exception e) {
                this.appendLoadError("Failed to parse package: %1$s", e.toString());
            }
        }
        return pkg;
    }
}

