/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.remote;

import com.android.annotations.NonNull;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

public class RemoteSdk {
    private DownloadCache mDownloadCache;
    private final SettingsController mSettingsController = this.initSettingsController();

    public Multimap<PkgType, RemotePkgInfo> fetch(@NonNull SdkSources sources, @NonNull ILogger logger) {
        HashMultimap remotes = HashMultimap.create();
        boolean forceHttp = this.getSettingsController().getSettings().getForceHttp();
        for (SdkSource source : sources.getAllSources()) {
            source.load(this.getDownloadCache(), new NullTaskMonitor(logger), forceHttp);
            Package[] pkgs = source.getPackages();
            if (pkgs == null || pkgs.length == 0) continue;
            for (Package p : pkgs) {
                IPkgDesc d = p.getPkgDesc();
                RemotePkgInfo r = new RemotePkgInfo(d, source);
                remotes.put((Object)d.getType(), (Object)r);
            }
        }
        return remotes;
    }

    protected DownloadCache getDownloadCache() {
        if (this.mDownloadCache == null) {
            this.mDownloadCache = new DownloadCache(this.getSettingsController().getSettings().getUseDownloadCache() ? DownloadCache.Strategy.FRESH_CACHE : DownloadCache.Strategy.DIRECT);
        }
        return this.mDownloadCache;
    }

    protected SettingsController getSettingsController() {
        return this.mSettingsController;
    }

    protected SettingsController initSettingsController() {
        SettingsController settingsController = new SettingsController((ILogger)new NullLogger());
        settingsController.registerOnChangedListener(new SettingsController.OnChangedListener(){

            @Override
            public void onSettingsChanged(SettingsController controller, SettingsController.Settings oldSettings) {
                RemoteSdk.this.mDownloadCache = null;
            }
        });
        return settingsController;
    }
}

