/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

public enum GpuMode {
    AUTO("auto"),
    HOST("host"),
    MESA("mesa"),
    SWIFT("guest"),
    OFF("off");

    private String mySetting;

    private GpuMode(String setting) {
        this.mySetting = setting;
    }

    public String toString() {
        switch (this) {
            case AUTO: {
                return "Automatic";
            }
            case HOST: {
                return "Hardware - GLES 2.0";
            }
            case MESA: 
            case SWIFT: {
                return "Software - GLES 2.0";
            }
        }
        return "Software - GLES 1.1";
    }

    public static GpuMode fromGpuSetting(String setting) {
        for (GpuMode mode : GpuMode.values()) {
            if (!mode.mySetting.equals(setting)) continue;
            return mode;
        }
        return OFF;
    }

    public String getGpuSetting() {
        return this.mySetting;
    }
}

