package com.spun.util.database;

import com.spun.util.ObjectUtils;
import com.sshtools.j2ssh.SshClient;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class SshConnection implements Connection
{
  private Connection con;
  private SshClient  ssh;
  private void closeSsh()
  {
    ssh.disconnect();
    ssh = null;
  }
  public SshConnection(SshClient ssh, Connection connection)
  {
    this.ssh = ssh;
    this.con = connection;
  }
  public int getHoldability()
  {
    return ObjectUtils.throwAsError(() -> con.getHoldability());
  }
  public int getTransactionIsolation()
  {
    return ObjectUtils.throwAsError(() -> con.getTransactionIsolation());
  }
  public void clearWarnings()
  {
    ObjectUtils.throwAsError(() -> con.clearWarnings());
  }
  public void close()
  {
    if (con != null)
    {
      ObjectUtils.throwAsError(() -> con.close());
      closeSsh();
      con = null;
    }
  }
  public void commit()
  {
    ObjectUtils.throwAsError(() -> con.commit());
  }
  public void rollback()
  {
    ObjectUtils.throwAsError(() -> con.rollback());
  }
  public boolean getAutoCommit()
  {
    return ObjectUtils.throwAsError(() -> con.getAutoCommit());
  }
  public boolean isClosed()
  {
    return ObjectUtils.throwAsError(() -> con.isClosed());
  }
  public boolean isReadOnly()
  {
    return ObjectUtils.throwAsError(() -> con.isReadOnly());
  }
  public void setHoldability(int holdability)
  {
    ObjectUtils.throwAsError(() -> con.setHoldability(holdability));
  }
  public void setTransactionIsolation(int level)
  {
    ObjectUtils.throwAsError(() -> con.setTransactionIsolation(level));
  }
  public void setAutoCommit(boolean autoCommit)
  {
    ObjectUtils.throwAsError(() -> con.setAutoCommit(autoCommit));
  }
  public void setReadOnly(boolean readOnly)
  {
    ObjectUtils.throwAsError(() -> con.setReadOnly(readOnly));
  }
  public String getCatalog()
  {
    return ObjectUtils.throwAsError(() -> con.getCatalog());
  }
  public void setCatalog(String catalog)
  {
    ObjectUtils.throwAsError(() -> con.setCatalog(catalog));
  }
  public DatabaseMetaData getMetaData()
  {
    return ObjectUtils.throwAsError(() -> con.getMetaData());
  }
  public SQLWarning getWarnings()
  {
    return ObjectUtils.throwAsError(() -> con.getWarnings());
  }
  public Savepoint setSavepoint()
  {
    return ObjectUtils.throwAsError(() -> con.setSavepoint());
  }
  public void releaseSavepoint(Savepoint savepoint)
  {
    ObjectUtils.throwAsError(() -> con.releaseSavepoint(savepoint));
  }
  public void rollback(Savepoint savepoint)
  {
    ObjectUtils.throwAsError(() -> con.rollback(savepoint));
  }
  public Statement createStatement()
  {
    return ObjectUtils.throwAsError(() -> con.createStatement());
  }
  public Statement createStatement(int resultSetType, int resultSetConcurrency)
  {
    return ObjectUtils.throwAsError(() -> con.createStatement(resultSetType, resultSetConcurrency));
  }
  public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)
  {
    return ObjectUtils
        .throwAsError(() -> con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
  }
  public Map<String, Class<?>> getTypeMap()
  {
    return ObjectUtils.throwAsError(() -> con.getTypeMap());
  }
  public void setTypeMap(Map<String, Class<?>> arg0)
  {
    ObjectUtils.throwAsError(() -> con.setTypeMap(arg0));
  }
  public String nativeSQL(String sql)
  {
    return ObjectUtils.throwAsError(() -> con.nativeSQL(sql));
  }
  public CallableStatement prepareCall(String sql)
  {
    return ObjectUtils.throwAsError(() -> con.prepareCall(sql));
  }
  public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency)
  {
    return ObjectUtils.throwAsError(() -> con.prepareCall(sql, resultSetType, resultSetConcurrency));
  }
  public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability)
  {
    return ObjectUtils
        .throwAsError(() -> con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
  }
  public PreparedStatement prepareStatement(String sql)
  {
    return ObjectUtils.throwAsError(() -> con.prepareStatement(sql));
  }
  public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)
  {
    return ObjectUtils.throwAsError(() -> con.prepareStatement(sql, autoGeneratedKeys));
  }
  public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency)
  {
    return ObjectUtils.throwAsError(() -> con.prepareStatement(sql, resultSetType, resultSetConcurrency));
  }
  public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability)
  {
    return ObjectUtils
        .throwAsError(() -> con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
  }
  public PreparedStatement prepareStatement(String sql, int[] columnIndexes)
  {
    return ObjectUtils.throwAsError(() -> con.prepareStatement(sql, columnIndexes));
  }
  public Savepoint setSavepoint(String name)
  {
    return ObjectUtils.throwAsError(() -> con.setSavepoint(name));
  }
  public PreparedStatement prepareStatement(String sql, String[] columnNames)
  {
    return ObjectUtils.throwAsError(() -> con.prepareStatement(sql, columnNames));
  }
  protected void finalize()
  {
    ObjectUtils.throwAsError(() -> super.finalize());
    close();
  }
  public Array createArrayOf(String arg0, Object[] arg1)
  {
    return ObjectUtils.throwAsError(() -> con.createArrayOf(arg0, arg1));
  }
  public Blob createBlob()
  {
    return ObjectUtils.throwAsError(() -> con.createBlob());
  }
  public Clob createClob()
  {
    return ObjectUtils.throwAsError(() -> con.createClob());
  }
  public NClob createNClob()
  {
    return ObjectUtils.throwAsError(() -> con.createNClob());
  }
  public SQLXML createSQLXML()
  {
    return ObjectUtils.throwAsError(() -> con.createSQLXML());
  }
  public Struct createStruct(String arg0, Object[] arg1)
  {
    return ObjectUtils.throwAsError(() -> con.createStruct(arg0, arg1));
  }
  public Properties getClientInfo()
  {
    return ObjectUtils.throwAsError(() -> con.getClientInfo());
  }
  public String getClientInfo(String arg0)
  {
    return ObjectUtils.throwAsError(() -> con.getClientInfo(arg0));
  }
  public boolean isValid(int arg0)
  {
    return ObjectUtils.throwAsError(() -> con.isValid(arg0));
  }
  public void setClientInfo(Properties arg0)
  {
    ObjectUtils.throwAsError(() -> con.setClientInfo(arg0));
  }
  public void setClientInfo(String arg0, String arg1)
  {
    ObjectUtils.throwAsError(() -> con.setClientInfo(arg0, arg1));
  }
  public boolean isWrapperFor(Class<?> arg0)
  {
    return ObjectUtils.throwAsError(() -> con.isWrapperFor(arg0));
  }
  public <T> T unwrap(Class<T> arg0)
  {
    return ObjectUtils.throwAsError(() -> con.unwrap(arg0));
  }
  public void abort(Executor executor)
  {
  }
  public int getNetworkTimeout()
  {
    return 0;
  }
  public String getSchema()
  {
    return null;
  }
  public void setNetworkTimeout(Executor executor, int milliseconds)
  {
  }
  public void setSchema(String schema)
  {
  }
}
