/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class NonAzureOpenAIClientImpl {
    private final NonAzureOpenAIClientService service;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    public static final String OPEN_AI_ENDPOINT = "https://api.openai.com/v1";

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public NonAzureOpenAIClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.service = (NonAzureOpenAIClientService)RestProxy.create(NonAzureOpenAIClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEmbeddingsWithResponseAsync(String modelId, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData embeddingsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(embeddingsOptions, modelId);
        return FluxUtil.withContext(context -> this.service.getEmbeddings(OPEN_AI_ENDPOINT, "application/json", embeddingsOptionsUpdated, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String modelId, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData embeddingsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(embeddingsOptions, modelId);
        return this.service.getEmbeddingsSync(OPEN_AI_ENDPOINT, "application/json", embeddingsOptionsUpdated, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCompletionsWithResponseAsync(String modelId, BinaryData completionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData completionsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(completionsOptions, modelId);
        return FluxUtil.withContext(context -> this.service.getCompletions(OPEN_AI_ENDPOINT, "application/json", completionsOptionsUpdated, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String modelId, BinaryData completionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData completionsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(completionsOptions, modelId);
        return this.service.getCompletionsSync(OPEN_AI_ENDPOINT, "application/json", completionsOptionsUpdated, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getChatCompletionsWithResponseAsync(String modelId, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData chatCompletionsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(chatCompletionsOptions, modelId);
        return FluxUtil.withContext(context -> this.service.getChatCompletions(OPEN_AI_ENDPOINT, "application/json", chatCompletionsOptionsUpdated, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String modelId, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData chatCompletionsOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(chatCompletionsOptions, modelId);
        return this.service.getChatCompletionsSync(OPEN_AI_ENDPOINT, "application/json", chatCompletionsOptionsUpdated, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getImageGenerationsWithResponseAsync(String modelId, BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData imageGenerationOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(imageGenerationOptions, modelId);
        return FluxUtil.withContext(context -> this.service.getImageGenerations(OPEN_AI_ENDPOINT, "application/json", imageGenerationOptionsUpdated, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getImageGenerationsWithResponse(String modelId, BinaryData imageGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        BinaryData imageGenerationOptionsUpdated = NonAzureOpenAIClientImpl.addModelIdJson(imageGenerationOptions, modelId);
        return this.service.getImageGenerationsSync(OPEN_AI_ENDPOINT, "application/json", imageGenerationOptionsUpdated, requestOptions, Context.NONE);
    }

    public static BinaryData addModelIdJson(BinaryData inputJson, String modelId) {
        Map mapJson = (Map)inputJson.toObject(Map.class);
        mapJson.put("model", modelId);
        inputJson = BinaryData.fromObject((Object)mapJson);
        return inputJson;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranscriptionAsResponseObjectWithResponseAsync(String modelId, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAudioTranscriptionAsResponseObject(OPEN_AI_ENDPOINT, "application/json", audioTranscriptionOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranscriptionAsResponseObjectWithResponse(String modelId, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getAudioTranscriptionAsResponseObjectSync(OPEN_AI_ENDPOINT, "application/json", audioTranscriptionOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranscriptionAsPlainTextWithResponseAsync(String modelId, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAudioTranscriptionAsPlainText(OPEN_AI_ENDPOINT, "application/json", audioTranscriptionOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranscriptionAsPlainTextWithResponse(String modelId, BinaryData audioTranscriptionOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getAudioTranscriptionAsPlainTextSync(OPEN_AI_ENDPOINT, "application/json", audioTranscriptionOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranslationAsResponseObjectWithResponseAsync(String deploymentOrModelName, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAudioTranslationAsResponseObject(OPEN_AI_ENDPOINT, "application/json", audioTranslationOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranslationAsResponseObjectWithResponse(String modelId, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getAudioTranslationAsResponseObjectSync(OPEN_AI_ENDPOINT, "application/json", audioTranslationOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAudioTranslationAsPlainTextWithResponseAsync(String modelId, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAudioTranslationAsPlainText(OPEN_AI_ENDPOINT, "application/json", audioTranslationOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAudioTranslationAsPlainTextWithResponse(String modelId, BinaryData audioTranslationOptions, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getAudioTranslationAsPlainTextSync(OPEN_AI_ENDPOINT, "application/json", audioTranslationOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> generateSpeechFromTextWithResponseAsync(String modelId, BinaryData speechGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/octet-stream, application/json";
        return FluxUtil.withContext(context -> this.service.generateSpeechFromText(OPEN_AI_ENDPOINT, "application/octet-stream, application/json", speechGenerationOptions, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> generateSpeechFromTextWithResponse(BinaryData speechGenerationOptions, RequestOptions requestOptions) {
        String accept = "application/octet-stream, application/json";
        return this.service.generateSpeechFromTextSync(OPEN_AI_ENDPOINT, "application/octet-stream, application/json", speechGenerationOptions, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listFilesWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFiles(OPEN_AI_ENDPOINT, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listFilesWithResponse(RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.listFilesSync(OPEN_AI_ENDPOINT, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> uploadFileWithResponseAsync(BinaryData uploadFileRequest, RequestOptions requestOptions) {
        String contentType = "multipart/form-data";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.uploadFile(OPEN_AI_ENDPOINT, "multipart/form-data", "application/json", uploadFileRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> uploadFileWithResponse(BinaryData uploadFileRequest, RequestOptions requestOptions) {
        String contentType = "multipart/form-data";
        String accept = "application/json";
        return this.service.uploadFileSync(OPEN_AI_ENDPOINT, "multipart/form-data", "application/json", uploadFileRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteFileWithResponseAsync(String fileId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteFile(OPEN_AI_ENDPOINT, fileId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteFileWithResponse(String fileId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteFileSync(OPEN_AI_ENDPOINT, fileId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getFileWithResponseAsync(String fileId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFile(OPEN_AI_ENDPOINT, fileId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileWithResponse(String fileId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getFileSync(OPEN_AI_ENDPOINT, fileId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getFileContentWithResponseAsync(String fileId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFileContent(OPEN_AI_ENDPOINT, fileId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileContentWithResponse(String fileId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getFileContentSync(OPEN_AI_ENDPOINT, fileId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listBatchesWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBatches(OPEN_AI_ENDPOINT, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listBatchesWithResponse(RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.listBatchesSync(OPEN_AI_ENDPOINT, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createBatchWithResponseAsync(BinaryData createBatchRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createBatch(OPEN_AI_ENDPOINT, "application/json", createBatchRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createBatchWithResponse(BinaryData createBatchRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.createBatchSync(OPEN_AI_ENDPOINT, "application/json", createBatchRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getBatchWithResponseAsync(String batchId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBatch(OPEN_AI_ENDPOINT, batchId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getBatchWithResponse(String batchId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getBatchSync(OPEN_AI_ENDPOINT, batchId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> cancelBatchWithResponseAsync(String batchId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelBatch(OPEN_AI_ENDPOINT, batchId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> cancelBatchWithResponse(String batchId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.cancelBatchSync(OPEN_AI_ENDPOINT, batchId, "application/json", requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="OpenAIClient")
    public static interface NonAzureOpenAIClientService {
        @Post(value="/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getEmbeddings(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/embeddings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getEmbeddingsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCompletions(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCompletionsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getChatCompletions(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/chat/completions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getChatCompletionsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/images/generations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getImageGenerations(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/images/generations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getImageGenerationsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/transcriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAudioTranscriptionAsResponseObject(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/transcriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAudioTranscriptionAsResponseObjectSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/transcriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAudioTranscriptionAsPlainText(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/transcriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAudioTranscriptionAsPlainTextSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/translations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAudioTranslationAsResponseObject(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/translations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAudioTranslationAsResponseObjectSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/translations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAudioTranslationAsPlainText(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/translations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getAudioTranslationAsPlainTextSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="multipart/form-data") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/speech")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> generateSpeechFromText(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/audio/speech")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> generateSpeechFromTextSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Get(value="/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listFiles(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, RequestOptions var3, Context var4);

        @Get(value="/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listFilesSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, RequestOptions var3, Context var4);

        @Post(value="/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> uploadFile(@HostParam(value="endpoint") String var1, @HeaderParam(value="content-type") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="multipart/form-data") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> uploadFileSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="content-type") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="multipart/form-data") BinaryData var4, RequestOptions var5, Context var6);

        @Delete(value="/files/{fileId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> deleteFile(@HostParam(value="endpoint") String var1, @PathParam(value="fileId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/files/{fileId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteFileSync(@HostParam(value="endpoint") String var1, @PathParam(value="fileId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/files/{fileId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getFile(@HostParam(value="endpoint") String var1, @PathParam(value="fileId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/files/{fileId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getFileSync(@HostParam(value="endpoint") String var1, @PathParam(value="fileId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/files/{fileId}/content")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getFileContent(@HostParam(value="endpoint") String var1, @PathParam(value="fileId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/files/{fileId}/content")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getFileContentSync(@HostParam(value="endpoint") String var1, @PathParam(value="fileId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/batches")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listBatches(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, RequestOptions var3, Context var4);

        @Get(value="/batches")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listBatchesSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, RequestOptions var3, Context var4);

        @Post(value="/batches")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createBatch(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Post(value="/batches")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createBatchSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="accept") String var2, @BodyParam(value="application/json") BinaryData var3, RequestOptions var4, Context var5);

        @Get(value="/batches/{batchId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getBatch(@HostParam(value="endpoint") String var1, @PathParam(value="batchId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/batches/{batchId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getBatchSync(@HostParam(value="endpoint") String var1, @PathParam(value="batchId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/batches/{batchId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> cancelBatch(@HostParam(value="endpoint") String var1, @PathParam(value="batchId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/batches/{batchId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> cancelBatchSync(@HostParam(value="endpoint") String var1, @PathParam(value="batchId") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);
    }
}

