/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ContentFilterDetailedResults;
import com.azure.ai.openai.models.ContentFilterDetectionResult;
import com.azure.ai.openai.models.ContentFilterResult;
import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContentFilterResultDetailsForPrompt
implements JsonSerializable<ContentFilterResultDetailsForPrompt> {
    private ContentFilterResult sexual;
    private ContentFilterResult violence;
    private ContentFilterResult hate;
    private ContentFilterResult selfHarm;
    private ContentFilterDetectionResult profanity;
    private ContentFilterDetailedResults customBlocklists;
    private ResponseError error;
    private ContentFilterDetectionResult jailbreak;
    private ContentFilterDetectionResult indirectAttack;

    public ContentFilterResult getSexual() {
        return this.sexual;
    }

    public ContentFilterResult getViolence() {
        return this.violence;
    }

    public ContentFilterResult getHate() {
        return this.hate;
    }

    public ContentFilterResult getSelfHarm() {
        return this.selfHarm;
    }

    public ContentFilterDetectionResult getProfanity() {
        return this.profanity;
    }

    public ContentFilterDetailedResults getCustomBlocklists() {
        return this.customBlocklists;
    }

    public ResponseError getError() {
        return this.error;
    }

    public ContentFilterDetectionResult getJailbreak() {
        return this.jailbreak;
    }

    private ContentFilterResultDetailsForPrompt() {
    }

    public ContentFilterDetectionResult getIndirectAttack() {
        return this.indirectAttack;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sexual", (JsonSerializable)this.sexual);
        jsonWriter.writeJsonField("violence", (JsonSerializable)this.violence);
        jsonWriter.writeJsonField("hate", (JsonSerializable)this.hate);
        jsonWriter.writeJsonField("self_harm", (JsonSerializable)this.selfHarm);
        jsonWriter.writeJsonField("profanity", (JsonSerializable)this.profanity);
        jsonWriter.writeJsonField("custom_blocklists", (JsonSerializable)this.customBlocklists);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("jailbreak", (JsonSerializable)this.jailbreak);
        jsonWriter.writeJsonField("indirect_attack", (JsonSerializable)this.indirectAttack);
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterResultDetailsForPrompt fromJson(JsonReader jsonReader) throws IOException {
        return (ContentFilterResultDetailsForPrompt)jsonReader.readObject(reader -> {
            ContentFilterResultDetailsForPrompt deserializedContentFilterResultDetailsForPrompt = new ContentFilterResultDetailsForPrompt();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sexual".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.sexual = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("violence".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.violence = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("hate".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.hate = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("self_harm".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.selfHarm = ContentFilterResult.fromJson(reader);
                    continue;
                }
                if ("profanity".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.profanity = ContentFilterDetectionResult.fromJson(reader);
                    continue;
                }
                if ("custom_blocklists".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.customBlocklists = ContentFilterDetailedResults.fromJson(reader);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("jailbreak".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.jailbreak = ContentFilterDetectionResult.fromJson(reader);
                    continue;
                }
                if ("indirect_attack".equals(fieldName)) {
                    deserializedContentFilterResultDetailsForPrompt.indirectAttack = ContentFilterDetectionResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContentFilterResultDetailsForPrompt;
        });
    }
}

