/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EmbeddingsUsage
implements JsonSerializable<EmbeddingsUsage> {
    private final int promptTokens;
    private final int totalTokens;

    private EmbeddingsUsage(int promptTokens, int totalTokens) {
        this.promptTokens = promptTokens;
        this.totalTokens = totalTokens;
    }

    public int getPromptTokens() {
        return this.promptTokens;
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("prompt_tokens", this.promptTokens);
        jsonWriter.writeIntField("total_tokens", this.totalTokens);
        return jsonWriter.writeEndObject();
    }

    public static EmbeddingsUsage fromJson(JsonReader jsonReader) throws IOException {
        return (EmbeddingsUsage)jsonReader.readObject(reader -> {
            int promptTokens = 0;
            int totalTokens = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("prompt_tokens".equals(fieldName)) {
                    promptTokens = reader.getInt();
                    continue;
                }
                if ("total_tokens".equals(fieldName)) {
                    totalTokens = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new EmbeddingsUsage(promptTokens, totalTokens);
        });
    }
}

