/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.util.HttpClientOptions;
import reactor.netty.resources.ConnectionProvider;

public final class NettyAsyncHttpClientProvider
implements HttpClientProvider {
    public HttpClient createInstance() {
        return new NettyAsyncHttpClientBuilder().build();
    }

    public HttpClient createInstance(HttpClientOptions clientOptions) {
        NettyAsyncHttpClientBuilder builder = new NettyAsyncHttpClientBuilder();
        if (clientOptions != null) {
            builder = builder.proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).writeTimeout(clientOptions.getWriteTimeout()).responseTimeout(clientOptions.getResponseTimeout()).readTimeout(clientOptions.getReadTimeout());
            int maximumConnectionPoolSize = clientOptions.getMaximumConnectionPoolSize();
            ConnectionProvider.Builder connectionProviderBuilder = ConnectionProvider.builder((String)"azure-sdk");
            connectionProviderBuilder.maxIdleTime(clientOptions.getConnectionIdleTimeout());
            if (maximumConnectionPoolSize > 0) {
                connectionProviderBuilder.maxConnections(maximumConnectionPoolSize);
            }
            builder = builder.connectionProvider(connectionProviderBuilder.build());
        }
        return builder.build();
    }
}

