/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ReadTimeoutHandler
extends ChannelInboundHandlerAdapter {
    public static final String HANDLER_NAME = "azureReadTimeoutHandler";
    private static final String READ_TIMED_OUT_MESSAGE = "Channel read timed out after %d milliseconds.";
    private final long timeoutMillis;
    private boolean closed;
    private long lastReadMillis;
    private ScheduledFuture<?> readTimeoutWatcher;

    public ReadTimeoutHandler(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.lastReadMillis = System.currentTimeMillis();
        ctx.fireChannelReadComplete();
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.timeoutMillis > 0L) {
            this.readTimeoutWatcher = ctx.executor().scheduleAtFixedRate(() -> this.readTimeoutRunnable(ctx), this.timeoutMillis, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.disposeWatcher();
    }

    private void readTimeoutRunnable(ChannelHandlerContext ctx) {
        if (this.timeoutMillis - (System.currentTimeMillis() - this.lastReadMillis) > 0L) {
            return;
        }
        if (!this.closed) {
            this.disposeWatcher();
            ctx.fireExceptionCaught((Throwable)new TimeoutException(String.format(READ_TIMED_OUT_MESSAGE, this.timeoutMillis)));
            ctx.close();
            this.closed = true;
        }
    }

    private void disposeWatcher() {
        if (this.readTimeoutWatcher != null && !this.readTimeoutWatcher.isDone()) {
            this.readTimeoutWatcher.cancel(false);
            this.readTimeoutWatcher = null;
        }
    }
}

