/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponseBase;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import okhttp3.Response;
import okhttp3.ResponseBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public final class OkHttpAsyncResponse
extends OkHttpAsyncResponseBase {
    private static final int BYTE_BUFFER_CHUNK_SIZE = 4096;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private final ResponseBody responseBody;

    public OkHttpAsyncResponse(Response response, HttpRequest request) {
        super(response, request);
        this.responseBody = response.body();
    }

    public Flux<ByteBuffer> getBody() {
        if (this.responseBody == null) {
            return Flux.empty();
        }
        return Flux.using(() -> ((ResponseBody)this.responseBody).byteStream(), OkHttpAsyncResponse::toFluxByteBuffer, bodyStream -> this.close(), (boolean)false);
    }

    private static Flux<ByteBuffer> toFluxByteBuffer(InputStream responseBody) {
        return Flux.just((Object)true).repeat().flatMap(ignored -> {
            byte[] buffer = new byte[4096];
            try {
                int read = responseBody.read(buffer);
                if (read > 0) {
                    return Mono.just((Object)Tuples.of((Object)read, (Object)ByteBuffer.wrap(buffer, 0, read)));
                }
                return Mono.just((Object)Tuples.of((Object)read, (Object)EMPTY_BYTE_BUFFER));
            }
            catch (IOException ex) {
                return Mono.error((Throwable)ex);
            }
        }).takeUntil(tuple -> (Integer)tuple.getT1() == -1).filter(tuple -> (Integer)tuple.getT1() > 0).map(Tuple2::getT2);
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.fromCallable(() -> {
            if (this.responseBody == null) {
                return null;
            }
            byte[] content = this.responseBody.bytes();
            if (content.length == 0) {
                return null;
            }
            return content;
        });
    }

    public Mono<InputStream> getBodyAsInputStream() {
        if (this.responseBody == null) {
            return Mono.empty();
        }
        return Mono.using(() -> ((ResponseBody)this.responseBody).byteStream(), Mono::just, ignored -> this.close());
    }

    public void close() {
        if (this.responseBody != null) {
            this.responseBody.close();
        }
    }
}

