/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management;

import com.azure.core.management.ResourceAuthorIdentityType;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SystemData
implements JsonSerializable<SystemData> {
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String createdBy;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private ResourceAuthorIdentityType createdByType;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String lastModifiedBy;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private ResourceAuthorIdentityType lastModifiedByType;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedAt;

    public String createdBy() {
        return this.createdBy;
    }

    public ResourceAuthorIdentityType createdByType() {
        return this.createdByType;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public ResourceAuthorIdentityType lastModifiedByType() {
        return this.lastModifiedByType;
    }

    public OffsetDateTime lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeEndObject();
    }

    public static SystemData fromJson(JsonReader jsonReader) throws IOException {
        return (SystemData)jsonReader.readObject(reader -> {
            SystemData systemData = new SystemData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdBy".equals(fieldName)) {
                    systemData.createdBy = reader.getString();
                    continue;
                }
                if ("createdByType".equals(fieldName)) {
                    systemData.createdByType = ResourceAuthorIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    systemData.createdAt = CoreUtils.parseBestOffsetDateTime((String)reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    systemData.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("lastModifiedByType".equals(fieldName)) {
                    systemData.lastModifiedByType = ResourceAuthorIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("lastModifiedAt".equals(fieldName)) {
                    systemData.lastModifiedAt = CoreUtils.parseBestOffsetDateTime((String)reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return systemData;
        });
    }
}

