/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.data.tables.models.TableTransactionAction;
import com.azure.data.tables.models.TableTransactionActionResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TableTransactionResult {
    private final List<TableTransactionActionResponse> transactionActionResponses;
    private final Map<String, TableTransactionActionResponse> lookupMap;

    public TableTransactionResult(List<TableTransactionAction> transactionActions, List<TableTransactionActionResponse> transactionActionResponses) {
        this.transactionActionResponses = transactionActionResponses;
        this.lookupMap = new HashMap<String, TableTransactionActionResponse>();
        for (int i = 0; i < transactionActions.size(); ++i) {
            this.lookupMap.put(transactionActions.get(i).getEntity().getRowKey(), transactionActionResponses.get(i));
        }
    }

    public List<TableTransactionActionResponse> getTransactionActionResponses() {
        return this.transactionActionResponses;
    }

    public TableTransactionActionResponse getTableTransactionActionResponseByRowKey(String rowKey) {
        return this.lookupMap.get(rowKey);
    }
}

