// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatParticipantAddedToThreadWithUser
 * event.
 */
@Fluent
public final class AcsChatParticipantAddedToThreadWithUserEventData extends AcsChatThreadEventBaseProperties {
    /*
     * The time at which the user was added to the thread
     */
    private OffsetDateTime time;

    /*
     * The communication identifier of the user who added the user
     */
    private CommunicationIdentifierModel addedByCommunicationIdentifier;

    /*
     * The details of the user who was added
     */
    private AcsChatThreadParticipantProperties participantAdded;

    /**
     * Creates an instance of AcsChatParticipantAddedToThreadWithUserEventData class.
     */
    public AcsChatParticipantAddedToThreadWithUserEventData() {
    }

    /**
     * Get the time property: The time at which the user was added to the thread.
     * 
     * @return the time value.
     */
    public OffsetDateTime getTime() {
        return this.time;
    }

    /**
     * Set the time property: The time at which the user was added to the thread.
     * 
     * @param time the time value to set.
     * @return the AcsChatParticipantAddedToThreadWithUserEventData object itself.
     */
    public AcsChatParticipantAddedToThreadWithUserEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the addedByCommunicationIdentifier property: The communication identifier of the user who added the user.
     * 
     * @return the addedByCommunicationIdentifier value.
     */
    public CommunicationIdentifierModel getAddedByCommunicationIdentifier() {
        return this.addedByCommunicationIdentifier;
    }

    /**
     * Set the addedByCommunicationIdentifier property: The communication identifier of the user who added the user.
     * 
     * @param addedByCommunicationIdentifier the addedByCommunicationIdentifier value to set.
     * @return the AcsChatParticipantAddedToThreadWithUserEventData object itself.
     */
    public AcsChatParticipantAddedToThreadWithUserEventData
        setAddedByCommunicationIdentifier(CommunicationIdentifierModel addedByCommunicationIdentifier) {
        this.addedByCommunicationIdentifier = addedByCommunicationIdentifier;
        return this;
    }

    /**
     * Get the participantAdded property: The details of the user who was added.
     * 
     * @return the participantAdded value.
     */
    public AcsChatThreadParticipantProperties getParticipantAdded() {
        return this.participantAdded;
    }

    /**
     * Set the participantAdded property: The details of the user who was added.
     * 
     * @param participantAdded the participantAdded value to set.
     * @return the AcsChatParticipantAddedToThreadWithUserEventData object itself.
     */
    public AcsChatParticipantAddedToThreadWithUserEventData
        setParticipantAdded(AcsChatThreadParticipantProperties participantAdded) {
        this.participantAdded = participantAdded;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData
        setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("createTime",
            getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getCreateTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeStringField("time",
            this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeJsonField("addedByCommunicationIdentifier", this.addedByCommunicationIdentifier);
        jsonWriter.writeJsonField("participantAdded", this.participantAdded);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatParticipantAddedToThreadWithUserEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatParticipantAddedToThreadWithUserEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsChatParticipantAddedToThreadWithUserEventData.
     */
    public static AcsChatParticipantAddedToThreadWithUserEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatParticipantAddedToThreadWithUserEventData deserializedAcsChatParticipantAddedToThreadWithUserEventData
                = new AcsChatParticipantAddedToThreadWithUserEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData
                        .setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setThreadId(reader.getString());
                } else if ("createTime".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setCreateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData
                        .setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("time".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.time = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("addedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.addedByCommunicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("participantAdded".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.participantAdded
                        = AcsChatThreadParticipantProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsChatParticipantAddedToThreadWithUserEventData;
        });
    }
}
