// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatThreadPropertiesUpdatedPerUser
 * event.
 */
@Fluent
public final class AcsChatThreadPropertiesUpdatedPerUserEventData extends AcsChatThreadEventBaseProperties {
    /*
     * The communication identifier of the user who updated the thread properties
     */
    private CommunicationIdentifierModel editedByCommunicationIdentifier;

    /*
     * The time at which the properties of the thread were updated
     */
    private OffsetDateTime editTime;

    /*
     * The thread metadata
     */
    private Map<String, String> metadata;

    /*
     * The updated thread properties
     */
    private Map<String, Object> properties;

    /**
     * Creates an instance of AcsChatThreadPropertiesUpdatedPerUserEventData class.
     */
    public AcsChatThreadPropertiesUpdatedPerUserEventData() {
    }

    /**
     * Get the editedByCommunicationIdentifier property: The communication identifier of the user who updated the thread
     * properties.
     * 
     * @return the editedByCommunicationIdentifier value.
     */
    public CommunicationIdentifierModel getEditedByCommunicationIdentifier() {
        return this.editedByCommunicationIdentifier;
    }

    /**
     * Set the editedByCommunicationIdentifier property: The communication identifier of the user who updated the thread
     * properties.
     * 
     * @param editedByCommunicationIdentifier the editedByCommunicationIdentifier value to set.
     * @return the AcsChatThreadPropertiesUpdatedPerUserEventData object itself.
     */
    public AcsChatThreadPropertiesUpdatedPerUserEventData
        setEditedByCommunicationIdentifier(CommunicationIdentifierModel editedByCommunicationIdentifier) {
        this.editedByCommunicationIdentifier = editedByCommunicationIdentifier;
        return this;
    }

    /**
     * Get the editTime property: The time at which the properties of the thread were updated.
     * 
     * @return the editTime value.
     */
    public OffsetDateTime getEditTime() {
        return this.editTime;
    }

    /**
     * Set the editTime property: The time at which the properties of the thread were updated.
     * 
     * @param editTime the editTime value to set.
     * @return the AcsChatThreadPropertiesUpdatedPerUserEventData object itself.
     */
    public AcsChatThreadPropertiesUpdatedPerUserEventData setEditTime(OffsetDateTime editTime) {
        this.editTime = editTime;
        return this;
    }

    /**
     * Get the metadata property: The thread metadata.
     * 
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The thread metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the AcsChatThreadPropertiesUpdatedPerUserEventData object itself.
     */
    public AcsChatThreadPropertiesUpdatedPerUserEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the properties property: The updated thread properties.
     * 
     * @return the properties value.
     */
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: The updated thread properties.
     * 
     * @param properties the properties value to set.
     * @return the AcsChatThreadPropertiesUpdatedPerUserEventData object itself.
     */
    public AcsChatThreadPropertiesUpdatedPerUserEventData setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatThreadPropertiesUpdatedPerUserEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatThreadPropertiesUpdatedPerUserEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatThreadPropertiesUpdatedPerUserEventData
        setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatThreadPropertiesUpdatedPerUserEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AcsChatThreadPropertiesUpdatedPerUserEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("createTime",
            getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getCreateTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeJsonField("editedByCommunicationIdentifier", this.editedByCommunicationIdentifier);
        jsonWriter.writeStringField("editTime",
            this.editTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.editTime));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatThreadPropertiesUpdatedPerUserEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatThreadPropertiesUpdatedPerUserEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsChatThreadPropertiesUpdatedPerUserEventData.
     */
    public static AcsChatThreadPropertiesUpdatedPerUserEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatThreadPropertiesUpdatedPerUserEventData deserializedAcsChatThreadPropertiesUpdatedPerUserEventData
                = new AcsChatThreadPropertiesUpdatedPerUserEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData
                        .setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                } else if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData.setThreadId(reader.getString());
                } else if ("createTime".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData.setCreateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData
                        .setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("editedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData.editedByCommunicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("editTime".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData.editTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData.metadata = metadata;
                } else if ("properties".equals(fieldName)) {
                    Map<String, Object> properties = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedAcsChatThreadPropertiesUpdatedPerUserEventData.properties = properties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsChatThreadPropertiesUpdatedPerUserEventData;
        });
    }
}
