// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.EmailEngagementTrackingReportReceived
 * event.
 */
@Fluent
public final class AcsEmailEngagementTrackingReportReceivedEventData
    implements JsonSerializable<AcsEmailEngagementTrackingReportReceivedEventData> {
    /*
     * The Sender Email Address
     */
    private String sender;

    /*
     * The Recipient Email Address
     */
    private String recipient;

    /*
     * The Id of the email that has been sent
     */
    private String messageId;

    /*
     * The time at which the user interacted with the email
     */
    private OffsetDateTime userActionTimestamp;

    /*
     * The context of the type of engagement user had with email
     */
    private String engagementContext;

    /*
     * The user agent interacting with the email
     */
    private String userAgent;

    /*
     * The type of engagement user have with email
     */
    private AcsUserEngagement engagement;

    /**
     * Creates an instance of AcsEmailEngagementTrackingReportReceivedEventData class.
     */
    public AcsEmailEngagementTrackingReportReceivedEventData() {
    }

    /**
     * Get the sender property: The Sender Email Address.
     * 
     * @return the sender value.
     */
    public String getSender() {
        return this.sender;
    }

    /**
     * Set the sender property: The Sender Email Address.
     * 
     * @param sender the sender value to set.
     * @return the AcsEmailEngagementTrackingReportReceivedEventData object itself.
     */
    public AcsEmailEngagementTrackingReportReceivedEventData setSender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * Get the recipient property: The Recipient Email Address.
     * 
     * @return the recipient value.
     */
    public String getRecipient() {
        return this.recipient;
    }

    /**
     * Set the recipient property: The Recipient Email Address.
     * 
     * @param recipient the recipient value to set.
     * @return the AcsEmailEngagementTrackingReportReceivedEventData object itself.
     */
    public AcsEmailEngagementTrackingReportReceivedEventData setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    /**
     * Get the messageId property: The Id of the email that has been sent.
     * 
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The Id of the email that has been sent.
     * 
     * @param messageId the messageId value to set.
     * @return the AcsEmailEngagementTrackingReportReceivedEventData object itself.
     */
    public AcsEmailEngagementTrackingReportReceivedEventData setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the userActionTimestamp property: The time at which the user interacted with the email.
     * 
     * @return the userActionTimestamp value.
     */
    public OffsetDateTime getUserActionTimestamp() {
        return this.userActionTimestamp;
    }

    /**
     * Set the userActionTimestamp property: The time at which the user interacted with the email.
     * 
     * @param userActionTimestamp the userActionTimestamp value to set.
     * @return the AcsEmailEngagementTrackingReportReceivedEventData object itself.
     */
    public AcsEmailEngagementTrackingReportReceivedEventData
        setUserActionTimestamp(OffsetDateTime userActionTimestamp) {
        this.userActionTimestamp = userActionTimestamp;
        return this;
    }

    /**
     * Get the engagementContext property: The context of the type of engagement user had with email.
     * 
     * @return the engagementContext value.
     */
    public String getEngagementContext() {
        return this.engagementContext;
    }

    /**
     * Set the engagementContext property: The context of the type of engagement user had with email.
     * 
     * @param engagementContext the engagementContext value to set.
     * @return the AcsEmailEngagementTrackingReportReceivedEventData object itself.
     */
    public AcsEmailEngagementTrackingReportReceivedEventData setEngagementContext(String engagementContext) {
        this.engagementContext = engagementContext;
        return this;
    }

    /**
     * Get the userAgent property: The user agent interacting with the email.
     * 
     * @return the userAgent value.
     */
    public String getUserAgent() {
        return this.userAgent;
    }

    /**
     * Set the userAgent property: The user agent interacting with the email.
     * 
     * @param userAgent the userAgent value to set.
     * @return the AcsEmailEngagementTrackingReportReceivedEventData object itself.
     */
    public AcsEmailEngagementTrackingReportReceivedEventData setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    /**
     * Get the engagement property: The type of engagement user have with email.
     * 
     * @return the engagement value.
     */
    public AcsUserEngagement getEngagement() {
        return this.engagement;
    }

    /**
     * Set the engagement property: The type of engagement user have with email.
     * 
     * @param engagement the engagement value to set.
     * @return the AcsEmailEngagementTrackingReportReceivedEventData object itself.
     */
    public AcsEmailEngagementTrackingReportReceivedEventData setEngagement(AcsUserEngagement engagement) {
        this.engagement = engagement;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sender", this.sender);
        jsonWriter.writeStringField("recipient", this.recipient);
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeStringField("userActionTimestamp",
            this.userActionTimestamp == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.userActionTimestamp));
        jsonWriter.writeStringField("engagementContext", this.engagementContext);
        jsonWriter.writeStringField("userAgent", this.userAgent);
        jsonWriter.writeStringField("engagementType", this.engagement == null ? null : this.engagement.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsEmailEngagementTrackingReportReceivedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsEmailEngagementTrackingReportReceivedEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsEmailEngagementTrackingReportReceivedEventData.
     */
    public static AcsEmailEngagementTrackingReportReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsEmailEngagementTrackingReportReceivedEventData deserializedAcsEmailEngagementTrackingReportReceivedEventData
                = new AcsEmailEngagementTrackingReportReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sender".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.sender = reader.getString();
                } else if ("recipient".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.recipient = reader.getString();
                } else if ("messageId".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.messageId = reader.getString();
                } else if ("userActionTimestamp".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.userActionTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("engagementContext".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.engagementContext
                        = reader.getString();
                } else if ("userAgent".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.userAgent = reader.getString();
                } else if ("engagementType".equals(fieldName)) {
                    deserializedAcsEmailEngagementTrackingReportReceivedEventData.engagement
                        = AcsUserEngagement.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsEmailEngagementTrackingReportReceivedEventData;
        });
    }
}
