// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of common properties of all Router events.
 */
@Fluent
public class AcsRouterEventData implements JsonSerializable<AcsRouterEventData> {
    /*
     * Router Event Job ID
     */
    private String jobId;

    /*
     * Router Event Channel Reference
     */
    private String channelReference;

    /*
     * Router Event Channel ID
     */
    private String channelId;

    /**
     * Creates an instance of AcsRouterEventData class.
     */
    public AcsRouterEventData() {
    }

    /**
     * Get the jobId property: Router Event Job ID.
     * 
     * @return the jobId value.
     */
    public String getJobId() {
        return this.jobId;
    }

    /**
     * Set the jobId property: Router Event Job ID.
     * 
     * @param jobId the jobId value to set.
     * @return the AcsRouterEventData object itself.
     */
    public AcsRouterEventData setJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    /**
     * Get the channelReference property: Router Event Channel Reference.
     * 
     * @return the channelReference value.
     */
    public String getChannelReference() {
        return this.channelReference;
    }

    /**
     * Set the channelReference property: Router Event Channel Reference.
     * 
     * @param channelReference the channelReference value to set.
     * @return the AcsRouterEventData object itself.
     */
    public AcsRouterEventData setChannelReference(String channelReference) {
        this.channelReference = channelReference;
        return this;
    }

    /**
     * Get the channelId property: Router Event Channel ID.
     * 
     * @return the channelId value.
     */
    public String getChannelId() {
        return this.channelId;
    }

    /**
     * Set the channelId property: Router Event Channel ID.
     * 
     * @param channelId the channelId value to set.
     * @return the AcsRouterEventData object itself.
     */
    public AcsRouterEventData setChannelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", this.jobId);
        jsonWriter.writeStringField("channelReference", this.channelReference);
        jsonWriter.writeStringField("channelId", this.channelId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterEventData if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsRouterEventData.
     */
    public static AcsRouterEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterEventData deserializedAcsRouterEventData = new AcsRouterEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterEventData.jobId = reader.getString();
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterEventData.channelReference = reader.getString();
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterEventData.channelId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcsRouterEventData;
        });
    }
}
