// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the data property of an EventGridEvent for a Microsoft.ApiCenter.ApiDefinitionAdded event.
 */
@Fluent
public final class ApiCenterApiDefinitionAddedEventData
    implements JsonSerializable<ApiCenterApiDefinitionAddedEventData> {
    /*
     * API definition title.
     */
    private String title;

    /*
     * API definition description.
     */
    private String description;

    /*
     * API specification details.
     */
    private ApiCenterApiSpecification specification;

    /**
     * Creates an instance of ApiCenterApiDefinitionAddedEventData class.
     */
    public ApiCenterApiDefinitionAddedEventData() {
    }

    /**
     * Get the title property: API definition title.
     * 
     * @return the title value.
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * Set the title property: API definition title.
     * 
     * @param title the title value to set.
     * @return the ApiCenterApiDefinitionAddedEventData object itself.
     */
    public ApiCenterApiDefinitionAddedEventData setTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: API definition description.
     * 
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: API definition description.
     * 
     * @param description the description value to set.
     * @return the ApiCenterApiDefinitionAddedEventData object itself.
     */
    public ApiCenterApiDefinitionAddedEventData setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the specification property: API specification details.
     * 
     * @return the specification value.
     */
    public ApiCenterApiSpecification getSpecification() {
        return this.specification;
    }

    /**
     * Set the specification property: API specification details.
     * 
     * @param specification the specification value to set.
     * @return the ApiCenterApiDefinitionAddedEventData object itself.
     */
    public ApiCenterApiDefinitionAddedEventData setSpecification(ApiCenterApiSpecification specification) {
        this.specification = specification;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("specification", this.specification);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiCenterApiDefinitionAddedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiCenterApiDefinitionAddedEventData if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiCenterApiDefinitionAddedEventData.
     */
    public static ApiCenterApiDefinitionAddedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiCenterApiDefinitionAddedEventData deserializedApiCenterApiDefinitionAddedEventData
                = new ApiCenterApiDefinitionAddedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedApiCenterApiDefinitionAddedEventData.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedApiCenterApiDefinitionAddedEventData.description = reader.getString();
                } else if ("specification".equals(fieldName)) {
                    deserializedApiCenterApiDefinitionAddedEventData.specification
                        = ApiCenterApiSpecification.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiCenterApiDefinitionAddedEventData;
        });
    }
}
