// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.AppConfiguration.KeyValueModified event.
 */
@Fluent
public final class AppConfigurationKeyValueModifiedEventData
    implements JsonSerializable<AppConfigurationKeyValueModifiedEventData> {
    /*
     * The key used to identify the key-value that was modified.
     */
    private String key;

    /*
     * The label, if any, used to identify the key-value that was modified.
     */
    private String label;

    /*
     * The etag representing the new state of the key-value.
     */
    private String etag;

    /*
     * The sync token representing the server state after the event.
     */
    private String syncToken;

    /**
     * Creates an instance of AppConfigurationKeyValueModifiedEventData class.
     */
    public AppConfigurationKeyValueModifiedEventData() {
    }

    /**
     * Get the key property: The key used to identify the key-value that was modified.
     * 
     * @return the key value.
     */
    public String getKey() {
        return this.key;
    }

    /**
     * Set the key property: The key used to identify the key-value that was modified.
     * 
     * @param key the key value to set.
     * @return the AppConfigurationKeyValueModifiedEventData object itself.
     */
    public AppConfigurationKeyValueModifiedEventData setKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Get the label property: The label, if any, used to identify the key-value that was modified.
     * 
     * @return the label value.
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: The label, if any, used to identify the key-value that was modified.
     * 
     * @param label the label value to set.
     * @return the AppConfigurationKeyValueModifiedEventData object itself.
     */
    public AppConfigurationKeyValueModifiedEventData setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the etag property: The etag representing the new state of the key-value.
     * 
     * @return the etag value.
     */
    public String getEtag() {
        return this.etag;
    }

    /**
     * Set the etag property: The etag representing the new state of the key-value.
     * 
     * @param etag the etag value to set.
     * @return the AppConfigurationKeyValueModifiedEventData object itself.
     */
    public AppConfigurationKeyValueModifiedEventData setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the syncToken property: The sync token representing the server state after the event.
     * 
     * @return the syncToken value.
     */
    public String getSyncToken() {
        return this.syncToken;
    }

    /**
     * Set the syncToken property: The sync token representing the server state after the event.
     * 
     * @param syncToken the syncToken value to set.
     * @return the AppConfigurationKeyValueModifiedEventData object itself.
     */
    public AppConfigurationKeyValueModifiedEventData setSyncToken(String syncToken) {
        this.syncToken = syncToken;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeStringField("syncToken", this.syncToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppConfigurationKeyValueModifiedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppConfigurationKeyValueModifiedEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AppConfigurationKeyValueModifiedEventData.
     */
    public static AppConfigurationKeyValueModifiedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppConfigurationKeyValueModifiedEventData deserializedAppConfigurationKeyValueModifiedEventData
                = new AppConfigurationKeyValueModifiedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedAppConfigurationKeyValueModifiedEventData.key = reader.getString();
                } else if ("label".equals(fieldName)) {
                    deserializedAppConfigurationKeyValueModifiedEventData.label = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedAppConfigurationKeyValueModifiedEventData.etag = reader.getString();
                } else if ("syncToken".equals(fieldName)) {
                    deserializedAppConfigurationKeyValueModifiedEventData.syncToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppConfigurationKeyValueModifiedEventData;
        });
    }
}
