// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for Microsoft.AVS/privateClouds events.
 */
@Fluent
public class AvsPrivateCloudEventData implements JsonSerializable<AvsPrivateCloudEventData> {
    /*
     * Id of the operation that caused this event.
     */
    private String operationId;

    /**
     * Creates an instance of AvsPrivateCloudEventData class.
     */
    public AvsPrivateCloudEventData() {
    }

    /**
     * Get the operationId property: Id of the operation that caused this event.
     * 
     * @return the operationId value.
     */
    public String getOperationId() {
        return this.operationId;
    }

    /**
     * Set the operationId property: Id of the operation that caused this event.
     * 
     * @param operationId the operationId value to set.
     * @return the AvsPrivateCloudEventData object itself.
     */
    public AvsPrivateCloudEventData setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", this.operationId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvsPrivateCloudEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvsPrivateCloudEventData if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvsPrivateCloudEventData.
     */
    public static AvsPrivateCloudEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvsPrivateCloudEventData deserializedAvsPrivateCloudEventData = new AvsPrivateCloudEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operationId".equals(fieldName)) {
                    deserializedAvsPrivateCloudEventData.operationId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvsPrivateCloudEventData;
        });
    }
}
