// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.AVS.PrivateCloudUpdated event.
 */
@Fluent
public final class AvsPrivateCloudUpdatedEventData extends AvsPrivateCloudEventData {
    /**
     * Creates an instance of AvsPrivateCloudUpdatedEventData class.
     */
    public AvsPrivateCloudUpdatedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AvsPrivateCloudUpdatedEventData setOperationId(String operationId) {
        super.setOperationId(operationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", getOperationId());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvsPrivateCloudUpdatedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvsPrivateCloudUpdatedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvsPrivateCloudUpdatedEventData.
     */
    public static AvsPrivateCloudUpdatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvsPrivateCloudUpdatedEventData deserializedAvsPrivateCloudUpdatedEventData
                = new AvsPrivateCloudUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operationId".equals(fieldName)) {
                    deserializedAvsPrivateCloudUpdatedEventData.setOperationId(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvsPrivateCloudUpdatedEventData;
        });
    }
}
