// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.ContainerService.ClusterSupportEnding event.
 */
@Fluent
public final class ContainerServiceClusterSupportEndingEventData extends ContainerServiceClusterSupportEventData {
    /**
     * Creates an instance of ContainerServiceClusterSupportEndingEventData class.
     */
    public ContainerServiceClusterSupportEndingEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ContainerServiceClusterSupportEndingEventData setKubernetesVersion(String kubernetesVersion) {
        super.setKubernetesVersion(kubernetesVersion);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubernetesVersion", getKubernetesVersion());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerServiceClusterSupportEndingEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerServiceClusterSupportEndingEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerServiceClusterSupportEndingEventData.
     */
    public static ContainerServiceClusterSupportEndingEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerServiceClusterSupportEndingEventData deserializedContainerServiceClusterSupportEndingEventData
                = new ContainerServiceClusterSupportEndingEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedContainerServiceClusterSupportEndingEventData.setKubernetesVersion(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerServiceClusterSupportEndingEventData;
        });
    }
}
