// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties JSON element.
 */
@Fluent
public final class DeviceTwinInfoProperties implements JsonSerializable<DeviceTwinInfoProperties> {
    /*
     * A portion of the properties that can be written only by the application back-end, and read by the device.
     */
    private DeviceTwinProperties desired;

    /*
     * A portion of the properties that can be written only by the device, and read by the application back-end.
     */
    private DeviceTwinProperties reported;

    /**
     * Creates an instance of DeviceTwinInfoProperties class.
     */
    public DeviceTwinInfoProperties() {
    }

    /**
     * Get the desired property: A portion of the properties that can be written only by the application back-end, and
     * read by the device.
     * 
     * @return the desired value.
     */
    public DeviceTwinProperties getDesired() {
        return this.desired;
    }

    /**
     * Set the desired property: A portion of the properties that can be written only by the application back-end, and
     * read by the device.
     * 
     * @param desired the desired value to set.
     * @return the DeviceTwinInfoProperties object itself.
     */
    public DeviceTwinInfoProperties setDesired(DeviceTwinProperties desired) {
        this.desired = desired;
        return this;
    }

    /**
     * Get the reported property: A portion of the properties that can be written only by the device, and read by the
     * application back-end.
     * 
     * @return the reported value.
     */
    public DeviceTwinProperties getReported() {
        return this.reported;
    }

    /**
     * Set the reported property: A portion of the properties that can be written only by the device, and read by the
     * application back-end.
     * 
     * @param reported the reported value to set.
     * @return the DeviceTwinInfoProperties object itself.
     */
    public DeviceTwinInfoProperties setReported(DeviceTwinProperties reported) {
        this.reported = reported;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("desired", this.desired);
        jsonWriter.writeJsonField("reported", this.reported);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeviceTwinInfoProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeviceTwinInfoProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeviceTwinInfoProperties.
     */
    public static DeviceTwinInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeviceTwinInfoProperties deserializedDeviceTwinInfoProperties = new DeviceTwinInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("desired".equals(fieldName)) {
                    deserializedDeviceTwinInfoProperties.desired = DeviceTwinProperties.fromJson(reader);
                } else if ("reported".equals(fieldName)) {
                    deserializedDeviceTwinInfoProperties.reported = DeviceTwinProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeviceTwinInfoProperties;
        });
    }
}
