// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Event data for Microsoft.EventGrid.MQTTClientSessionConnected event.
 */
@Fluent
public final class EventGridMqttClientSessionConnectedEventData extends EventGridMqttClientEventData {
    /*
     * Unique identifier for the MQTT client's session. This case-sensitive string can be up to 128 characters long, and
     * supports UTF-8 characters.
     */
    private String clientSessionName;

    /*
     * A number that helps indicate order of MQTT client session connected or disconnected events. Latest event will
     * have a sequence number that is higher than the previous event.
     */
    private Long sequenceNumber;

    /**
     * Creates an instance of EventGridMqttClientSessionConnectedEventData class.
     */
    public EventGridMqttClientSessionConnectedEventData() {
    }

    /**
     * Get the clientSessionName property: Unique identifier for the MQTT client's session. This case-sensitive string
     * can be up to 128 characters long, and supports UTF-8 characters.
     * 
     * @return the clientSessionName value.
     */
    public String getClientSessionName() {
        return this.clientSessionName;
    }

    /**
     * Set the clientSessionName property: Unique identifier for the MQTT client's session. This case-sensitive string
     * can be up to 128 characters long, and supports UTF-8 characters.
     * 
     * @param clientSessionName the clientSessionName value to set.
     * @return the EventGridMqttClientSessionConnectedEventData object itself.
     */
    public EventGridMqttClientSessionConnectedEventData setClientSessionName(String clientSessionName) {
        this.clientSessionName = clientSessionName;
        return this;
    }

    /**
     * Get the sequenceNumber property: A number that helps indicate order of MQTT client session connected or
     * disconnected events. Latest event will have a sequence number that is higher than the previous event.
     * 
     * @return the sequenceNumber value.
     */
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    /**
     * Set the sequenceNumber property: A number that helps indicate order of MQTT client session connected or
     * disconnected events. Latest event will have a sequence number that is higher than the previous event.
     * 
     * @param sequenceNumber the sequenceNumber value to set.
     * @return the EventGridMqttClientSessionConnectedEventData object itself.
     */
    public EventGridMqttClientSessionConnectedEventData setSequenceNumber(Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventGridMqttClientSessionConnectedEventData setClientAuthenticationName(String clientAuthenticationName) {
        super.setClientAuthenticationName(clientAuthenticationName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventGridMqttClientSessionConnectedEventData setClientName(String clientName) {
        super.setClientName(clientName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventGridMqttClientSessionConnectedEventData setNamespaceName(String namespaceName) {
        super.setNamespaceName(namespaceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientAuthenticationName", getClientAuthenticationName());
        jsonWriter.writeStringField("clientName", getClientName());
        jsonWriter.writeStringField("namespaceName", getNamespaceName());
        jsonWriter.writeStringField("clientSessionName", this.clientSessionName);
        jsonWriter.writeNumberField("sequenceNumber", this.sequenceNumber);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventGridMqttClientSessionConnectedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventGridMqttClientSessionConnectedEventData if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventGridMqttClientSessionConnectedEventData.
     */
    public static EventGridMqttClientSessionConnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventGridMqttClientSessionConnectedEventData deserializedEventGridMqttClientSessionConnectedEventData
                = new EventGridMqttClientSessionConnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientAuthenticationName".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionConnectedEventData
                        .setClientAuthenticationName(reader.getString());
                } else if ("clientName".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionConnectedEventData.setClientName(reader.getString());
                } else if ("namespaceName".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionConnectedEventData.setNamespaceName(reader.getString());
                } else if ("clientSessionName".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionConnectedEventData.clientSessionName = reader.getString();
                } else if ("sequenceNumber".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionConnectedEventData.sequenceNumber
                        = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventGridMqttClientSessionConnectedEventData;
        });
    }
}
