// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Event data for Microsoft.EventGrid.MQTTClientSessionDisconnected event.
 */
@Fluent
public final class EventGridMqttClientSessionDisconnectedEventData extends EventGridMqttClientEventData {
    /*
     * Unique identifier for the MQTT client's session. This case-sensitive string can be up to 128 characters long, and
     * supports UTF-8 characters.
     */
    private String clientSessionName;

    /*
     * A number that helps indicate order of MQTT client session connected or disconnected events. Latest event will
     * have a sequence number that is higher than the previous event.
     */
    private Long sequenceNumber;

    /*
     * Reason for the disconnection of the MQTT client's session. The value could be one of the values in the
     * disconnection reasons table.
     */
    private EventGridMqttClientDisconnectionReason disconnectionReason;

    /**
     * Creates an instance of EventGridMqttClientSessionDisconnectedEventData class.
     */
    public EventGridMqttClientSessionDisconnectedEventData() {
    }

    /**
     * Get the clientSessionName property: Unique identifier for the MQTT client's session. This case-sensitive string
     * can be up to 128 characters long, and supports UTF-8 characters.
     * 
     * @return the clientSessionName value.
     */
    public String getClientSessionName() {
        return this.clientSessionName;
    }

    /**
     * Set the clientSessionName property: Unique identifier for the MQTT client's session. This case-sensitive string
     * can be up to 128 characters long, and supports UTF-8 characters.
     * 
     * @param clientSessionName the clientSessionName value to set.
     * @return the EventGridMqttClientSessionDisconnectedEventData object itself.
     */
    public EventGridMqttClientSessionDisconnectedEventData setClientSessionName(String clientSessionName) {
        this.clientSessionName = clientSessionName;
        return this;
    }

    /**
     * Get the sequenceNumber property: A number that helps indicate order of MQTT client session connected or
     * disconnected events. Latest event will have a sequence number that is higher than the previous event.
     * 
     * @return the sequenceNumber value.
     */
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    /**
     * Set the sequenceNumber property: A number that helps indicate order of MQTT client session connected or
     * disconnected events. Latest event will have a sequence number that is higher than the previous event.
     * 
     * @param sequenceNumber the sequenceNumber value to set.
     * @return the EventGridMqttClientSessionDisconnectedEventData object itself.
     */
    public EventGridMqttClientSessionDisconnectedEventData setSequenceNumber(Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    /**
     * Get the disconnectionReason property: Reason for the disconnection of the MQTT client's session. The value could
     * be one of the values in the disconnection reasons table.
     * 
     * @return the disconnectionReason value.
     */
    public EventGridMqttClientDisconnectionReason getDisconnectionReason() {
        return this.disconnectionReason;
    }

    /**
     * Set the disconnectionReason property: Reason for the disconnection of the MQTT client's session. The value could
     * be one of the values in the disconnection reasons table.
     * 
     * @param disconnectionReason the disconnectionReason value to set.
     * @return the EventGridMqttClientSessionDisconnectedEventData object itself.
     */
    public EventGridMqttClientSessionDisconnectedEventData
        setDisconnectionReason(EventGridMqttClientDisconnectionReason disconnectionReason) {
        this.disconnectionReason = disconnectionReason;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventGridMqttClientSessionDisconnectedEventData
        setClientAuthenticationName(String clientAuthenticationName) {
        super.setClientAuthenticationName(clientAuthenticationName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventGridMqttClientSessionDisconnectedEventData setClientName(String clientName) {
        super.setClientName(clientName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventGridMqttClientSessionDisconnectedEventData setNamespaceName(String namespaceName) {
        super.setNamespaceName(namespaceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientAuthenticationName", getClientAuthenticationName());
        jsonWriter.writeStringField("clientName", getClientName());
        jsonWriter.writeStringField("namespaceName", getNamespaceName());
        jsonWriter.writeStringField("clientSessionName", this.clientSessionName);
        jsonWriter.writeNumberField("sequenceNumber", this.sequenceNumber);
        jsonWriter.writeStringField("disconnectionReason",
            this.disconnectionReason == null ? null : this.disconnectionReason.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventGridMqttClientSessionDisconnectedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventGridMqttClientSessionDisconnectedEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventGridMqttClientSessionDisconnectedEventData.
     */
    public static EventGridMqttClientSessionDisconnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventGridMqttClientSessionDisconnectedEventData deserializedEventGridMqttClientSessionDisconnectedEventData
                = new EventGridMqttClientSessionDisconnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientAuthenticationName".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionDisconnectedEventData
                        .setClientAuthenticationName(reader.getString());
                } else if ("clientName".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionDisconnectedEventData.setClientName(reader.getString());
                } else if ("namespaceName".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionDisconnectedEventData.setNamespaceName(reader.getString());
                } else if ("clientSessionName".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionDisconnectedEventData.clientSessionName = reader.getString();
                } else if ("sequenceNumber".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionDisconnectedEventData.sequenceNumber
                        = reader.getNullable(JsonReader::getLong);
                } else if ("disconnectionReason".equals(fieldName)) {
                    deserializedEventGridMqttClientSessionDisconnectedEventData.disconnectionReason
                        = EventGridMqttClientDisconnectionReason.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventGridMqttClientSessionDisconnectedEventData;
        });
    }
}
