// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Maps.GeofenceResult event.
 */
@Fluent
public final class MapsGeofenceResultEventData extends MapsGeofenceEventProperties {
    /**
     * Creates an instance of MapsGeofenceResultEventData class.
     */
    public MapsGeofenceResultEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MapsGeofenceResultEventData setExpiredGeofenceGeometryId(List<String> expiredGeofenceGeometryId) {
        super.setExpiredGeofenceGeometryId(expiredGeofenceGeometryId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MapsGeofenceResultEventData setGeometries(List<MapsGeofenceGeometry> geometries) {
        super.setGeometries(geometries);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MapsGeofenceResultEventData
        setInvalidPeriodGeofenceGeometryId(List<String> invalidPeriodGeofenceGeometryId) {
        super.setInvalidPeriodGeofenceGeometryId(invalidPeriodGeofenceGeometryId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MapsGeofenceResultEventData setIsEventPublished(Boolean isEventPublished) {
        super.setIsEventPublished(isEventPublished);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("expiredGeofenceGeometryId", getExpiredGeofenceGeometryId(),
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("geometries", getGeometries(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("invalidPeriodGeofenceGeometryId", getInvalidPeriodGeofenceGeometryId(),
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isEventPublished", isEventPublished());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MapsGeofenceResultEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MapsGeofenceResultEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MapsGeofenceResultEventData.
     */
    public static MapsGeofenceResultEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MapsGeofenceResultEventData deserializedMapsGeofenceResultEventData = new MapsGeofenceResultEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expiredGeofenceGeometryId".equals(fieldName)) {
                    List<String> expiredGeofenceGeometryId = reader.readArray(reader1 -> reader1.getString());
                    deserializedMapsGeofenceResultEventData.setExpiredGeofenceGeometryId(expiredGeofenceGeometryId);
                } else if ("geometries".equals(fieldName)) {
                    List<MapsGeofenceGeometry> geometries
                        = reader.readArray(reader1 -> MapsGeofenceGeometry.fromJson(reader1));
                    deserializedMapsGeofenceResultEventData.setGeometries(geometries);
                } else if ("invalidPeriodGeofenceGeometryId".equals(fieldName)) {
                    List<String> invalidPeriodGeofenceGeometryId = reader.readArray(reader1 -> reader1.getString());
                    deserializedMapsGeofenceResultEventData
                        .setInvalidPeriodGeofenceGeometryId(invalidPeriodGeofenceGeometryId);
                } else if ("isEventPublished".equals(fieldName)) {
                    deserializedMapsGeofenceResultEventData
                        .setIsEventPublished(reader.getNullable(JsonReader::getBoolean));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMapsGeofenceResultEventData;
        });
    }
}
