// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details of JobOutput errors.
 */
@Immutable
public final class MediaJobErrorDetail implements JsonSerializable<MediaJobErrorDetail> {
    /*
     * Code describing the error detail.
     */
    private String code;

    /*
     * A human-readable representation of the error.
     */
    private String message;

    /**
     * Creates an instance of MediaJobErrorDetail class.
     */
    public MediaJobErrorDetail() {
    }

    /**
     * Get the code property: Code describing the error detail.
     * 
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: A human-readable representation of the error.
     * 
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaJobErrorDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaJobErrorDetail if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaJobErrorDetail.
     */
    public static MediaJobErrorDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaJobErrorDetail deserializedMediaJobErrorDetail = new MediaJobErrorDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedMediaJobErrorDetail.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedMediaJobErrorDetail.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMediaJobErrorDetail;
        });
    }
}
