// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A phone number.
 */
@Fluent
public final class PhoneNumberIdentifierModel implements JsonSerializable<PhoneNumberIdentifierModel> {
    /*
     * The phone number in E.164 format.
     */
    private String value;

    /**
     * Creates an instance of PhoneNumberIdentifierModel class.
     */
    public PhoneNumberIdentifierModel() {
    }

    /**
     * Get the value property: The phone number in E.164 format.
     * 
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Set the value property: The phone number in E.164 format.
     * 
     * @param value the value value to set.
     * @return the PhoneNumberIdentifierModel object itself.
     */
    public PhoneNumberIdentifierModel setValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PhoneNumberIdentifierModel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PhoneNumberIdentifierModel if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PhoneNumberIdentifierModel.
     */
    public static PhoneNumberIdentifierModel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PhoneNumberIdentifierModel deserializedPhoneNumberIdentifierModel = new PhoneNumberIdentifierModel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedPhoneNumberIdentifierModel.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPhoneNumberIdentifierModel;
        });
    }
}
