// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an event grid event for a
 * Microsoft.ResourceNotifications.ContainerServiceEventResources.ScheduledEventEmitted preview event.
 */
@Fluent
public final class ResourceNotificationsContainerServiceEventResourcesScheduledEventData
    extends ResourceNotificationsResourceUpdatedEventData {
    /**
     * Creates an instance of ResourceNotificationsContainerServiceEventResourcesScheduledEventData class.
     */
    public ResourceNotificationsContainerServiceEventResourcesScheduledEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceNotificationsContainerServiceEventResourcesScheduledEventData
        setResourceDetails(ResourceNotificationsResourceUpdatedDetails resourceDetails) {
        super.setResourceDetails(resourceDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceNotificationsContainerServiceEventResourcesScheduledEventData
        setOperationalDetails(ResourceNotificationsOperationalDetails operationalDetails) {
        super.setOperationalDetails(operationalDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceNotificationsContainerServiceEventResourcesScheduledEventData setApiVersion(String apiVersion) {
        super.setApiVersion(apiVersion);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceInfo", getResourceDetails());
        jsonWriter.writeJsonField("operationalInfo", getOperationalDetails());
        jsonWriter.writeStringField("apiVersion", getApiVersion());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceNotificationsContainerServiceEventResourcesScheduledEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceNotificationsContainerServiceEventResourcesScheduledEventData if the JsonReader
     * was pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ResourceNotificationsContainerServiceEventResourcesScheduledEventData.
     */
    public static ResourceNotificationsContainerServiceEventResourcesScheduledEventData fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceNotificationsContainerServiceEventResourcesScheduledEventData deserializedResourceNotificationsContainerServiceEventResourcesScheduledEventData
                = new ResourceNotificationsContainerServiceEventResourcesScheduledEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceInfo".equals(fieldName)) {
                    deserializedResourceNotificationsContainerServiceEventResourcesScheduledEventData
                        .setResourceDetails(ResourceNotificationsResourceUpdatedDetails.fromJson(reader));
                } else if ("operationalInfo".equals(fieldName)) {
                    deserializedResourceNotificationsContainerServiceEventResourcesScheduledEventData
                        .setOperationalDetails(ResourceNotificationsOperationalDetails.fromJson(reader));
                } else if ("apiVersion".equals(fieldName)) {
                    deserializedResourceNotificationsContainerServiceEventResourcesScheduledEventData
                        .setApiVersion(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceNotificationsContainerServiceEventResourcesScheduledEventData;
        });
    }
}
