// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Policy status can be Completed/CompletedWithError/Incomplete.
 */
public final class StorageLifecycleCompletionStatus extends ExpandableStringEnum<StorageLifecycleCompletionStatus> {
    /**
     * Static value Completed for StorageLifecycleCompletionStatus.
     */
    public static final StorageLifecycleCompletionStatus COMPLETED = fromString("Completed");

    /**
     * Static value CompletedWithError for StorageLifecycleCompletionStatus.
     */
    public static final StorageLifecycleCompletionStatus COMPLETED_WITH_ERROR = fromString("CompletedWithError");

    /**
     * Static value Incomplete for StorageLifecycleCompletionStatus.
     */
    public static final StorageLifecycleCompletionStatus INCOMPLETE = fromString("Incomplete");

    /**
     * Creates a new instance of StorageLifecycleCompletionStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public StorageLifecycleCompletionStatus() {
    }

    /**
     * Creates or finds a StorageLifecycleCompletionStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding StorageLifecycleCompletionStatus.
     */
    public static StorageLifecycleCompletionStatus fromString(String name) {
        return fromString(name, StorageLifecycleCompletionStatus.class);
    }

    /**
     * Gets known StorageLifecycleCompletionStatus values.
     * 
     * @return known StorageLifecycleCompletionStatus values.
     */
    public static Collection<StorageLifecycleCompletionStatus> values() {
        return values(StorageLifecycleCompletionStatus.class);
    }
}
