// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Web.AppServicePlanUpdated event.
 */
@Fluent
public final class WebAppServicePlanUpdatedEventData implements JsonSerializable<WebAppServicePlanUpdatedEventData> {
    /*
     * Detail of action on the app service plan.
     */
    private AppServicePlanEventTypeDetail appServicePlanEventTypeDetail;

    /*
     * sku of app service plan.
     */
    private WebAppServicePlanUpdatedEventDataSku sku;

    /*
     * name of the app service plan that had this event.
     */
    private String name;

    /*
     * The client request id generated by the app service for the app service plan API operation that triggered this
     * event.
     */
    private String clientRequestId;

    /*
     * The correlation request id generated by the app service for the app service plan API operation that triggered
     * this event.
     */
    private String correlationRequestId;

    /*
     * The request id generated by the app service for the app service plan API operation that triggered this event.
     */
    private String requestId;

    /*
     * HTTP request URL of this operation.
     */
    private String address;

    /*
     * HTTP verb of this operation.
     */
    private String verb;

    /**
     * Creates an instance of WebAppServicePlanUpdatedEventData class.
     */
    public WebAppServicePlanUpdatedEventData() {
    }

    /**
     * Get the appServicePlanEventTypeDetail property: Detail of action on the app service plan.
     * 
     * @return the appServicePlanEventTypeDetail value.
     */
    public AppServicePlanEventTypeDetail getAppServicePlanEventTypeDetail() {
        return this.appServicePlanEventTypeDetail;
    }

    /**
     * Set the appServicePlanEventTypeDetail property: Detail of action on the app service plan.
     * 
     * @param appServicePlanEventTypeDetail the appServicePlanEventTypeDetail value to set.
     * @return the WebAppServicePlanUpdatedEventData object itself.
     */
    public WebAppServicePlanUpdatedEventData
        setAppServicePlanEventTypeDetail(AppServicePlanEventTypeDetail appServicePlanEventTypeDetail) {
        this.appServicePlanEventTypeDetail = appServicePlanEventTypeDetail;
        return this;
    }

    /**
     * Get the sku property: sku of app service plan.
     * 
     * @return the sku value.
     */
    public WebAppServicePlanUpdatedEventDataSku getSku() {
        return this.sku;
    }

    /**
     * Set the sku property: sku of app service plan.
     * 
     * @param sku the sku value to set.
     * @return the WebAppServicePlanUpdatedEventData object itself.
     */
    public WebAppServicePlanUpdatedEventData setSku(WebAppServicePlanUpdatedEventDataSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the name property: name of the app service plan that had this event.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: name of the app service plan that had this event.
     * 
     * @param name the name value to set.
     * @return the WebAppServicePlanUpdatedEventData object itself.
     */
    public WebAppServicePlanUpdatedEventData setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the clientRequestId property: The client request id generated by the app service for the app service plan API
     * operation that triggered this event.
     * 
     * @return the clientRequestId value.
     */
    public String getClientRequestId() {
        return this.clientRequestId;
    }

    /**
     * Set the clientRequestId property: The client request id generated by the app service for the app service plan API
     * operation that triggered this event.
     * 
     * @param clientRequestId the clientRequestId value to set.
     * @return the WebAppServicePlanUpdatedEventData object itself.
     */
    public WebAppServicePlanUpdatedEventData setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    /**
     * Get the correlationRequestId property: The correlation request id generated by the app service for the app
     * service plan API operation that triggered this event.
     * 
     * @return the correlationRequestId value.
     */
    public String getCorrelationRequestId() {
        return this.correlationRequestId;
    }

    /**
     * Set the correlationRequestId property: The correlation request id generated by the app service for the app
     * service plan API operation that triggered this event.
     * 
     * @param correlationRequestId the correlationRequestId value to set.
     * @return the WebAppServicePlanUpdatedEventData object itself.
     */
    public WebAppServicePlanUpdatedEventData setCorrelationRequestId(String correlationRequestId) {
        this.correlationRequestId = correlationRequestId;
        return this;
    }

    /**
     * Get the requestId property: The request id generated by the app service for the app service plan API operation
     * that triggered this event.
     * 
     * @return the requestId value.
     */
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * Set the requestId property: The request id generated by the app service for the app service plan API operation
     * that triggered this event.
     * 
     * @param requestId the requestId value to set.
     * @return the WebAppServicePlanUpdatedEventData object itself.
     */
    public WebAppServicePlanUpdatedEventData setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    /**
     * Get the address property: HTTP request URL of this operation.
     * 
     * @return the address value.
     */
    public String getAddress() {
        return this.address;
    }

    /**
     * Set the address property: HTTP request URL of this operation.
     * 
     * @param address the address value to set.
     * @return the WebAppServicePlanUpdatedEventData object itself.
     */
    public WebAppServicePlanUpdatedEventData setAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Get the verb property: HTTP verb of this operation.
     * 
     * @return the verb value.
     */
    public String getVerb() {
        return this.verb;
    }

    /**
     * Set the verb property: HTTP verb of this operation.
     * 
     * @param verb the verb value to set.
     * @return the WebAppServicePlanUpdatedEventData object itself.
     */
    public WebAppServicePlanUpdatedEventData setVerb(String verb) {
        this.verb = verb;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("appServicePlanEventTypeDetail", this.appServicePlanEventTypeDetail);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("clientRequestId", this.clientRequestId);
        jsonWriter.writeStringField("correlationRequestId", this.correlationRequestId);
        jsonWriter.writeStringField("requestId", this.requestId);
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeStringField("verb", this.verb);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebAppServicePlanUpdatedEventData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebAppServicePlanUpdatedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebAppServicePlanUpdatedEventData.
     */
    public static WebAppServicePlanUpdatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebAppServicePlanUpdatedEventData deserializedWebAppServicePlanUpdatedEventData
                = new WebAppServicePlanUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appServicePlanEventTypeDetail".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventData.appServicePlanEventTypeDetail
                        = AppServicePlanEventTypeDetail.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventData.sku
                        = WebAppServicePlanUpdatedEventDataSku.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventData.name = reader.getString();
                } else if ("clientRequestId".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventData.clientRequestId = reader.getString();
                } else if ("correlationRequestId".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventData.correlationRequestId = reader.getString();
                } else if ("requestId".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventData.requestId = reader.getString();
                } else if ("address".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventData.address = reader.getString();
                } else if ("verb".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventData.verb = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebAppServicePlanUpdatedEventData;
        });
    }
}
