// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * sku of app service plan.
 */
@Fluent
public final class WebAppServicePlanUpdatedEventDataSku
    implements JsonSerializable<WebAppServicePlanUpdatedEventDataSku> {
    /*
     * name of app service plan sku.
     */
    private String name;

    /*
     * tier of app service plan sku.
     */
    private String tier;

    /*
     * size of app service plan sku.
     */
    private String size;

    /*
     * family of app service plan sku.
     */
    private String family;

    /*
     * capacity of app service plan sku.
     */
    private String capacity;

    /**
     * Creates an instance of WebAppServicePlanUpdatedEventDataSku class.
     */
    public WebAppServicePlanUpdatedEventDataSku() {
    }

    /**
     * Get the name property: name of app service plan sku.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: name of app service plan sku.
     * 
     * @param name the name value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: tier of app service plan sku.
     * 
     * @return the tier value.
     */
    public String getTier() {
        return this.tier;
    }

    /**
     * Set the tier property: tier of app service plan sku.
     * 
     * @param tier the tier value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setTier(String tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the size property: size of app service plan sku.
     * 
     * @return the size value.
     */
    public String getSize() {
        return this.size;
    }

    /**
     * Set the size property: size of app service plan sku.
     * 
     * @param size the size value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setSize(String size) {
        this.size = size;
        return this;
    }

    /**
     * Get the family property: family of app service plan sku.
     * 
     * @return the family value.
     */
    public String getFamily() {
        return this.family;
    }

    /**
     * Set the family property: family of app service plan sku.
     * 
     * @param family the family value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setFamily(String family) {
        this.family = family;
        return this;
    }

    /**
     * Get the capacity property: capacity of app service plan sku.
     * 
     * @return the capacity value.
     */
    public String getCapacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: capacity of app service plan sku.
     * 
     * @param capacity the capacity value to set.
     * @return the WebAppServicePlanUpdatedEventDataSku object itself.
     */
    public WebAppServicePlanUpdatedEventDataSku setCapacity(String capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("Tier", this.tier);
        jsonWriter.writeStringField("Size", this.size);
        jsonWriter.writeStringField("Family", this.family);
        jsonWriter.writeStringField("Capacity", this.capacity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebAppServicePlanUpdatedEventDataSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebAppServicePlanUpdatedEventDataSku if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebAppServicePlanUpdatedEventDataSku.
     */
    public static WebAppServicePlanUpdatedEventDataSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebAppServicePlanUpdatedEventDataSku deserializedWebAppServicePlanUpdatedEventDataSku
                = new WebAppServicePlanUpdatedEventDataSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventDataSku.name = reader.getString();
                } else if ("Tier".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventDataSku.tier = reader.getString();
                } else if ("Size".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventDataSku.size = reader.getString();
                } else if ("Family".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventDataSku.family = reader.getString();
                } else if ("Capacity".equals(fieldName)) {
                    deserializedWebAppServicePlanUpdatedEventDataSku.capacity = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebAppServicePlanUpdatedEventDataSku;
        });
    }
}
