/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class AcsChatMessageEventInThreadBaseProperties
extends AcsChatEventInThreadBaseProperties {
    private String messageId;
    private CommunicationIdentifierModel senderCommunicationIdentifier;
    private String senderDisplayName;
    private OffsetDateTime composeTime;
    private String type;
    private Long version;

    public String getMessageId() {
        return this.messageId;
    }

    public AcsChatMessageEventInThreadBaseProperties setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public CommunicationIdentifierModel getSenderCommunicationIdentifier() {
        return this.senderCommunicationIdentifier;
    }

    public AcsChatMessageEventInThreadBaseProperties setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        this.senderCommunicationIdentifier = senderCommunicationIdentifier;
        return this;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public AcsChatMessageEventInThreadBaseProperties setSenderDisplayName(String senderDisplayName) {
        this.senderDisplayName = senderDisplayName;
        return this;
    }

    public OffsetDateTime getComposeTime() {
        return this.composeTime;
    }

    public AcsChatMessageEventInThreadBaseProperties setComposeTime(OffsetDateTime composeTime) {
        this.composeTime = composeTime;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public AcsChatMessageEventInThreadBaseProperties setType(String type) {
        this.type = type;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public AcsChatMessageEventInThreadBaseProperties setVersion(Long version) {
        this.version = version;
        return this;
    }

    @Override
    public AcsChatMessageEventInThreadBaseProperties setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatMessageEventInThreadBaseProperties setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("messageId", this.messageId);
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.senderCommunicationIdentifier);
        jsonWriter.writeStringField("senderDisplayName", this.senderDisplayName);
        jsonWriter.writeStringField("composeTime", this.composeTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.composeTime));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("version", (Number)this.version);
        return jsonWriter.writeEndObject();
    }

    public static AcsChatMessageEventInThreadBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatMessageEventInThreadBaseProperties)jsonReader.readObject(reader -> {
            AcsChatMessageEventInThreadBaseProperties deserializedAcsChatMessageEventInThreadBaseProperties = new AcsChatMessageEventInThreadBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageEventInThreadBaseProperties.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageEventInThreadBaseProperties.setThreadId(reader.getString());
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageEventInThreadBaseProperties.messageId = reader.getString();
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageEventInThreadBaseProperties.senderCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageEventInThreadBaseProperties.senderDisplayName = reader.getString();
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageEventInThreadBaseProperties.composeTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageEventInThreadBaseProperties.type = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageEventInThreadBaseProperties.version = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatMessageEventInThreadBaseProperties;
        });
    }
}

