/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.MediaJobErrorCategory;
import com.azure.messaging.eventgrid.systemevents.MediaJobErrorCode;
import com.azure.messaging.eventgrid.systemevents.MediaJobErrorDetail;
import com.azure.messaging.eventgrid.systemevents.MediaJobRetry;
import java.io.IOException;
import java.util.List;

public final class MediaJobError
implements JsonSerializable<MediaJobError> {
    private MediaJobErrorCode code;
    private String message;
    private MediaJobErrorCategory category;
    private MediaJobRetry retry;
    private List<MediaJobErrorDetail> details;

    public MediaJobErrorCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public MediaJobErrorCategory getCategory() {
        return this.category;
    }

    public MediaJobRetry getRetry() {
        return this.retry;
    }

    public List<MediaJobErrorDetail> getDetails() {
        return this.details;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MediaJobError fromJson(JsonReader jsonReader) throws IOException {
        return (MediaJobError)jsonReader.readObject(reader -> {
            MediaJobError deserializedMediaJobError = new MediaJobError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedMediaJobError.code = MediaJobErrorCode.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMediaJobError.message = reader.getString();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedMediaJobError.category = MediaJobErrorCategory.fromString(reader.getString());
                    continue;
                }
                if ("retry".equals(fieldName)) {
                    deserializedMediaJobError.retry = MediaJobRetry.fromString(reader.getString());
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedMediaJobError.details = details = reader.readArray(reader1 -> MediaJobErrorDetail.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaJobError;
        });
    }
}

