/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.MediaJobError;
import com.azure.messaging.eventgrid.systemevents.MediaJobOutputAsset;
import com.azure.messaging.eventgrid.systemevents.MediaJobState;
import java.io.IOException;

public class MediaJobOutput
implements JsonSerializable<MediaJobOutput> {
    private String odataType = "MediaJobOutput";
    private MediaJobError error;
    private String label;
    private long progress;
    private MediaJobState state;

    public String getOdataType() {
        return this.odataType;
    }

    public MediaJobError getError() {
        return this.error;
    }

    public MediaJobOutput setError(MediaJobError error) {
        this.error = error;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public MediaJobOutput setLabel(String label) {
        this.label = label;
        return this;
    }

    public long getProgress() {
        return this.progress;
    }

    public MediaJobOutput setProgress(long progress) {
        this.progress = progress;
        return this;
    }

    public MediaJobState getState() {
        return this.state;
    }

    public MediaJobOutput setState(MediaJobState state) {
        this.state = state;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("progress", this.progress);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("label", this.label);
        return jsonWriter.writeEndObject();
    }

    public static MediaJobOutput fromJson(JsonReader jsonReader) throws IOException {
        return (MediaJobOutput)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MediaJobOutput mediaJobOutput;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Media.JobOutputAsset".equals(discriminatorValue)) {
                    mediaJobOutput = MediaJobOutputAsset.fromJson(readerToUse.reset());
                    return mediaJobOutput;
                }
                mediaJobOutput = MediaJobOutput.fromJsonKnownDiscriminator(readerToUse.reset());
                return mediaJobOutput;
            }
        });
    }

    static MediaJobOutput fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MediaJobOutput)jsonReader.readObject(reader -> {
            MediaJobOutput deserializedMediaJobOutput = new MediaJobOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("progress".equals(fieldName)) {
                    deserializedMediaJobOutput.progress = reader.getLong();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMediaJobOutput.state = MediaJobState.fromString(reader.getString());
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    deserializedMediaJobOutput.odataType = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMediaJobOutput.error = MediaJobError.fromJson(reader);
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedMediaJobOutput.label = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaJobOutput;
        });
    }
}

