/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadParticipantProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsChatParticipantAddedToThreadEventData
extends AcsChatEventInThreadBaseProperties {
    private OffsetDateTime time;
    private CommunicationIdentifierModel addedByCommunicationIdentifier;
    private AcsChatThreadParticipantProperties participantAdded;
    private Long version;

    public OffsetDateTime getTime() {
        return this.time;
    }

    public AcsChatParticipantAddedToThreadEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public CommunicationIdentifierModel getAddedByCommunicationIdentifier() {
        return this.addedByCommunicationIdentifier;
    }

    public AcsChatParticipantAddedToThreadEventData setAddedByCommunicationIdentifier(CommunicationIdentifierModel addedByCommunicationIdentifier) {
        this.addedByCommunicationIdentifier = addedByCommunicationIdentifier;
        return this;
    }

    public AcsChatThreadParticipantProperties getParticipantAdded() {
        return this.participantAdded;
    }

    public AcsChatParticipantAddedToThreadEventData setParticipantAdded(AcsChatThreadParticipantProperties participantAdded) {
        this.participantAdded = participantAdded;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public AcsChatParticipantAddedToThreadEventData setVersion(Long version) {
        this.version = version;
        return this;
    }

    @Override
    public AcsChatParticipantAddedToThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatParticipantAddedToThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        jsonWriter.writeJsonField("addedByCommunicationIdentifier", (JsonSerializable)this.addedByCommunicationIdentifier);
        jsonWriter.writeJsonField("participantAdded", (JsonSerializable)this.participantAdded);
        jsonWriter.writeNumberField("version", (Number)this.version);
        return jsonWriter.writeEndObject();
    }

    public static AcsChatParticipantAddedToThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatParticipantAddedToThreadEventData)jsonReader.readObject(reader -> {
            AcsChatParticipantAddedToThreadEventData deserializedAcsChatParticipantAddedToThreadEventData = new AcsChatParticipantAddedToThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("addedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.addedByCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("participantAdded".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.participantAdded = AcsChatThreadParticipantProperties.fromJson(reader);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadEventData.version = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatParticipantAddedToThreadEventData;
        });
    }
}

