/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadEventBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsChatThreadWithUserDeletedEventData
extends AcsChatThreadEventBaseProperties {
    private CommunicationIdentifierModel deletedByCommunicationIdentifier;
    private OffsetDateTime deleteTime;

    public CommunicationIdentifierModel getDeletedByCommunicationIdentifier() {
        return this.deletedByCommunicationIdentifier;
    }

    public AcsChatThreadWithUserDeletedEventData setDeletedByCommunicationIdentifier(CommunicationIdentifierModel deletedByCommunicationIdentifier) {
        this.deletedByCommunicationIdentifier = deletedByCommunicationIdentifier;
        return this;
    }

    public OffsetDateTime getDeleteTime() {
        return this.deleteTime;
    }

    public AcsChatThreadWithUserDeletedEventData setDeleteTime(OffsetDateTime deleteTime) {
        this.deleteTime = deleteTime;
        return this;
    }

    @Override
    public AcsChatThreadWithUserDeletedEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    @Override
    public AcsChatThreadWithUserDeletedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatThreadWithUserDeletedEventData setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatThreadWithUserDeletedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatThreadWithUserDeletedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", (JsonSerializable)this.getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("createTime", this.getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreateTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeJsonField("deletedByCommunicationIdentifier", (JsonSerializable)this.deletedByCommunicationIdentifier);
        jsonWriter.writeStringField("deleteTime", this.deleteTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deleteTime));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatThreadWithUserDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatThreadWithUserDeletedEventData)jsonReader.readObject(reader -> {
            AcsChatThreadWithUserDeletedEventData deserializedAcsChatThreadWithUserDeletedEventData = new AcsChatThreadWithUserDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadWithUserDeletedEventData.setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatThreadWithUserDeletedEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatThreadWithUserDeletedEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedAcsChatThreadWithUserDeletedEventData.setCreateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatThreadWithUserDeletedEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("deletedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadWithUserDeletedEventData.deletedByCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("deleteTime".equals(fieldName)) {
                    deserializedAcsChatThreadWithUserDeletedEventData.deleteTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatThreadWithUserDeletedEventData;
        });
    }
}

