/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsRouterWorkerEventData;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class AcsRouterWorkerOfferIssuedEventData
extends AcsRouterWorkerEventData {
    private String queueId;
    private String offerId;
    private Integer jobPriority;
    private Map<String, String> workerLabels;
    private OffsetDateTime offeredOn;
    private OffsetDateTime expiresOn;
    private Map<String, String> workerTags;
    private Map<String, String> jobLabels;
    private Map<String, String> jobTags;

    public String getQueueId() {
        return this.queueId;
    }

    public AcsRouterWorkerOfferIssuedEventData setQueueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    public String getOfferId() {
        return this.offerId;
    }

    public AcsRouterWorkerOfferIssuedEventData setOfferId(String offerId) {
        this.offerId = offerId;
        return this;
    }

    public Integer getJobPriority() {
        return this.jobPriority;
    }

    public AcsRouterWorkerOfferIssuedEventData setJobPriority(Integer jobPriority) {
        this.jobPriority = jobPriority;
        return this;
    }

    public Map<String, String> getWorkerLabels() {
        return this.workerLabels;
    }

    public AcsRouterWorkerOfferIssuedEventData setWorkerLabels(Map<String, String> workerLabels) {
        this.workerLabels = workerLabels;
        return this;
    }

    public OffsetDateTime getOfferedOn() {
        return this.offeredOn;
    }

    public AcsRouterWorkerOfferIssuedEventData setOfferedOn(OffsetDateTime offeredOn) {
        this.offeredOn = offeredOn;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public AcsRouterWorkerOfferIssuedEventData setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public Map<String, String> getWorkerTags() {
        return this.workerTags;
    }

    public AcsRouterWorkerOfferIssuedEventData setWorkerTags(Map<String, String> workerTags) {
        this.workerTags = workerTags;
        return this;
    }

    public Map<String, String> getJobLabels() {
        return this.jobLabels;
    }

    public AcsRouterWorkerOfferIssuedEventData setJobLabels(Map<String, String> jobLabels) {
        this.jobLabels = jobLabels;
        return this;
    }

    public Map<String, String> getJobTags() {
        return this.jobTags;
    }

    public AcsRouterWorkerOfferIssuedEventData setJobTags(Map<String, String> jobTags) {
        this.jobTags = jobTags;
        return this;
    }

    @Override
    public AcsRouterWorkerOfferIssuedEventData setWorkerId(String workerId) {
        super.setWorkerId(workerId);
        return this;
    }

    @Override
    public AcsRouterWorkerOfferIssuedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    @Override
    public AcsRouterWorkerOfferIssuedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    @Override
    public AcsRouterWorkerOfferIssuedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", this.getJobId());
        jsonWriter.writeStringField("channelReference", this.getChannelReference());
        jsonWriter.writeStringField("channelId", this.getChannelId());
        jsonWriter.writeStringField("workerId", this.getWorkerId());
        jsonWriter.writeStringField("queueId", this.queueId);
        jsonWriter.writeStringField("offerId", this.offerId);
        jsonWriter.writeNumberField("jobPriority", (Number)this.jobPriority);
        jsonWriter.writeMapField("workerLabels", this.workerLabels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("offeredOn", this.offeredOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.offeredOn));
        jsonWriter.writeStringField("expiresOn", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        jsonWriter.writeMapField("workerTags", this.workerTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("jobLabels", this.jobLabels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("jobTags", this.jobTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AcsRouterWorkerOfferIssuedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRouterWorkerOfferIssuedEventData)jsonReader.readObject(reader -> {
            AcsRouterWorkerOfferIssuedEventData deserializedAcsRouterWorkerOfferIssuedEventData = new AcsRouterWorkerOfferIssuedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.setJobId(reader.getString());
                    continue;
                }
                if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.setChannelReference(reader.getString());
                    continue;
                }
                if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.setChannelId(reader.getString());
                    continue;
                }
                if ("workerId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.setWorkerId(reader.getString());
                    continue;
                }
                if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.queueId = reader.getString();
                    continue;
                }
                if ("offerId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.offerId = reader.getString();
                    continue;
                }
                if ("jobPriority".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.jobPriority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("workerLabels".equals(fieldName)) {
                    Map workerLabels;
                    deserializedAcsRouterWorkerOfferIssuedEventData.workerLabels = workerLabels = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("offeredOn".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.offeredOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expiresOn".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferIssuedEventData.expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("workerTags".equals(fieldName)) {
                    Map workerTags;
                    deserializedAcsRouterWorkerOfferIssuedEventData.workerTags = workerTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("jobLabels".equals(fieldName)) {
                    Map jobLabels;
                    deserializedAcsRouterWorkerOfferIssuedEventData.jobLabels = jobLabels = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("jobTags".equals(fieldName)) {
                    Map jobTags;
                    deserializedAcsRouterWorkerOfferIssuedEventData.jobTags = jobTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRouterWorkerOfferIssuedEventData;
        });
    }
}

