/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.DeviceLifeCycleEventProperties;
import com.azure.messaging.eventgrid.systemevents.DeviceTwinInfo;
import java.io.IOException;

public final class IotHubDeviceCreatedEventData
extends DeviceLifeCycleEventProperties {
    @Override
    public IotHubDeviceCreatedEventData setDeviceId(String deviceId) {
        super.setDeviceId(deviceId);
        return this;
    }

    @Override
    public IotHubDeviceCreatedEventData setHubName(String hubName) {
        super.setHubName(hubName);
        return this;
    }

    @Override
    public IotHubDeviceCreatedEventData setTwin(DeviceTwinInfo twin) {
        super.setTwin(twin);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceId", this.getDeviceId());
        jsonWriter.writeStringField("hubName", this.getHubName());
        jsonWriter.writeJsonField("twin", (JsonSerializable)this.getTwin());
        return jsonWriter.writeEndObject();
    }

    public static IotHubDeviceCreatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubDeviceCreatedEventData)jsonReader.readObject(reader -> {
            IotHubDeviceCreatedEventData deserializedIotHubDeviceCreatedEventData = new IotHubDeviceCreatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceId".equals(fieldName)) {
                    deserializedIotHubDeviceCreatedEventData.setDeviceId(reader.getString());
                    continue;
                }
                if ("hubName".equals(fieldName)) {
                    deserializedIotHubDeviceCreatedEventData.setHubName(reader.getString());
                    continue;
                }
                if ("twin".equals(fieldName)) {
                    deserializedIotHubDeviceCreatedEventData.setTwin(DeviceTwinInfo.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubDeviceCreatedEventData;
        });
    }
}

