/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.datalake.implementation.DataLakeStorageClientImpl;
import com.azure.storage.file.datalake.implementation.models.FileSystemsCreateResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsDeleteResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsGetPropertiesResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsSetPropertiesResponse;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class FileSystemsImpl {
    private FileSystemsService service;
    private DataLakeStorageClientImpl client;

    public FileSystemsImpl(DataLakeStorageClientImpl client) {
        this.service = (FileSystemsService)RestProxy.create(FileSystemsService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<FileSystemsCreateResponse> createWithRestResponseAsync(Context context) {
        String properties = null;
        String requestId = null;
        Integer timeout = null;
        return this.service.create(this.client.getUrl(), properties, this.client.getResource(), requestId, timeout, this.client.getVersion(), context);
    }

    public Mono<FileSystemsCreateResponse> createWithRestResponseAsync(String properties, String requestId, Integer timeout, Context context) {
        return this.service.create(this.client.getUrl(), properties, this.client.getResource(), requestId, timeout, this.client.getVersion(), context);
    }

    public Mono<FileSystemsSetPropertiesResponse> setPropertiesWithRestResponseAsync(Context context) {
        String properties = null;
        String requestId = null;
        Integer timeout = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.setProperties(this.client.getUrl(), properties, this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<FileSystemsSetPropertiesResponse> setPropertiesWithRestResponseAsync(String properties, String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setProperties(this.client.getUrl(), properties, this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<FileSystemsGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context) {
        String requestId = null;
        Integer timeout = null;
        return this.service.getProperties(this.client.getUrl(), this.client.getResource(), requestId, timeout, this.client.getVersion(), context);
    }

    public Mono<FileSystemsGetPropertiesResponse> getPropertiesWithRestResponseAsync(String requestId, Integer timeout, Context context) {
        return this.service.getProperties(this.client.getUrl(), this.client.getResource(), requestId, timeout, this.client.getVersion(), context);
    }

    public Mono<FileSystemsDeleteResponse> deleteWithRestResponseAsync(Context context) {
        String requestId = null;
        Integer timeout = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.delete(this.client.getUrl(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<FileSystemsDeleteResponse> deleteWithRestResponseAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<FileSystemsListPathsResponse> listPathsWithRestResponseAsync(boolean recursive, Context context) {
        String continuation = null;
        String path = null;
        Integer maxResults = null;
        Boolean upn = null;
        String requestId = null;
        Integer timeout = null;
        return this.service.listPaths(this.client.getFileSystem(), this.client.getUrl(), continuation, path, recursive, maxResults, upn, this.client.getResource(), requestId, timeout, this.client.getVersion(), context);
    }

    public Mono<FileSystemsListPathsResponse> listPathsWithRestResponseAsync(boolean recursive, String continuation, String path, Integer maxResults, Boolean upn, String requestId, Integer timeout, Context context) {
        return this.service.listPaths(this.client.getFileSystem(), this.client.getUrl(), continuation, path, recursive, maxResults, upn, this.client.getResource(), requestId, timeout, this.client.getVersion(), context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="DataLakeStorageClientFileSystems")
    private static interface FileSystemsService {
        @Put(value="{filesystem}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsCreateResponse> create(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-properties") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, Context var7);

        @Patch(value="{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-properties") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, Context var9);

        @Head(value="{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, Context var6);

        @Delete(value="{filesystem}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsDeleteResponse> delete(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, Context var8);

        @Get(value="{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsListPathsResponse> listPaths(@PathParam(value="filesystem") String var1, @HostParam(value="url") String var2, @QueryParam(value="continuation") String var3, @QueryParam(value="directory") String var4, @QueryParam(value="recursive") boolean var5, @QueryParam(value="maxResults") Integer var6, @QueryParam(value="upn") Boolean var7, @QueryParam(value="resource") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, Context var12);
    }
}

