/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class PathAppendDataHeaders {
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String clientRequestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="x-ms-content-crc64")
    private byte[] xMsContentCrc64;
    @JsonProperty(value="x-ms-request-server-encrypted")
    private Boolean isServerEncrypted;

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public PathAppendDataHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public PathAppendDataHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public PathAppendDataHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public PathAppendDataHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PathAppendDataHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public PathAppendDataHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone((byte[])this.xMsContentCrc64);
    }

    public PathAppendDataHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone((byte[])xMsContentCrc64);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public PathAppendDataHeaders setIsServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }
}

