/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.AADAuthorizationServerEndpoints;
import com.azure.spring.aad.webapp.AADOAuth2AuthorizedClientRepository;
import com.azure.spring.aad.webapp.AADOAuth2UserService;
import com.azure.spring.aad.webapp.AADWebAppClientRegistrationRepository;
import com.azure.spring.aad.webapp.AADWebSecurityConfigurerAdapter;
import com.azure.spring.aad.webapp.AuthorizationClientProperties;
import com.azure.spring.aad.webapp.AzureClientRegistration;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

@Configuration
@ConditionalOnMissingClass(value={"org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken"})
@ConditionalOnClass(value={ClientRegistrationRepository.class})
@ConditionalOnProperty(value={"azure.activedirectory.client-id"})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class})
public class AADWebAppConfiguration {
    @Autowired
    private AADAuthenticationProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={ClientRegistrationRepository.class, AADWebAppClientRegistrationRepository.class})
    public AADWebAppClientRegistrationRepository clientRegistrationRepository() {
        return new AADWebAppClientRegistrationRepository(this.createDefaultClient(), this.createAuthzClients(), this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizedClientRepository authorizedClientRepository(AADWebAppClientRegistrationRepository repo) {
        return new AADOAuth2AuthorizedClientRepository(repo);
    }

    @Bean
    public OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService(AADAuthenticationProperties properties) {
        return new AADOAuth2UserService(properties);
    }

    private AzureClientRegistration createDefaultClient() {
        ClientRegistration.Builder builder = this.createClientBuilder("azure");
        Set<String> authorizationCodeScopes = this.authorizationCodeScopes();
        builder.scope(authorizationCodeScopes);
        ClientRegistration client = builder.build();
        Set<String> accessTokenScopes = this.accessTokenScopes();
        if (AADWebAppConfiguration.resourceServerCount(accessTokenScopes) == 0 && AADWebAppConfiguration.resourceServerCount(authorizationCodeScopes) > 1) {
            accessTokenScopes.add(this.properties.getGraphBaseUri() + "User.Read");
        }
        return new AzureClientRegistration(client, accessTokenScopes);
    }

    public static int resourceServerCount(Set<String> scopes) {
        return (int)scopes.stream().filter(scope -> scope.contains("/")).map(scope -> scope.substring(0, scope.lastIndexOf(47))).distinct().count();
    }

    private Set<String> authorizationCodeScopes() {
        Set<String> result = this.accessTokenScopes();
        for (AuthorizationClientProperties authProperties : this.properties.getAuthorizationClients().values()) {
            if (authProperties.isOnDemand()) continue;
            result.addAll(authProperties.getScopes());
        }
        return result;
    }

    private Set<String> accessTokenScopes() {
        Set<String> result = Optional.of(this.properties).map(AADAuthenticationProperties::getAuthorizationClients).map(clients -> (AuthorizationClientProperties)clients.get("azure")).map(AuthorizationClientProperties::getScopes).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
        result.addAll(this.openidScopes());
        if (this.properties.allowedGroupsConfigured()) {
            result.add(this.properties.getGraphBaseUri() + "User.Read");
            result.add(this.properties.getGraphBaseUri() + "Directory.AccessAsUser.All");
        }
        return result;
    }

    private Set<String> openidScopes() {
        HashSet<String> result = new HashSet<String>();
        result.add("openid");
        result.add("profile");
        if (!this.properties.getAuthorizationClients().isEmpty()) {
            result.add("offline_access");
        }
        return result;
    }

    private List<ClientRegistration> createAuthzClients() {
        ArrayList<ClientRegistration> result = new ArrayList<ClientRegistration>();
        for (String name : this.properties.getAuthorizationClients().keySet()) {
            if ("azure".equals(name)) continue;
            AuthorizationClientProperties authz = this.properties.getAuthorizationClients().get(name);
            result.add(this.createClientBuilder(name, authz));
        }
        return result;
    }

    private ClientRegistration createClientBuilder(String id, AuthorizationClientProperties authz) {
        ClientRegistration.Builder result = this.createClientBuilder(id);
        List<String> scopes = authz.getScopes();
        if (authz.isOnDemand()) {
            if (!scopes.contains("openid")) {
                scopes.add("openid");
            }
            if (!scopes.contains("profile")) {
                scopes.add("profile");
            }
        }
        result.scope(scopes);
        return result.build();
    }

    private ClientRegistration.Builder createClientBuilder(String id) {
        ClientRegistration.Builder result = ClientRegistration.withRegistrationId((String)id);
        result.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        result.redirectUriTemplate("{baseUrl}/login/oauth2/code/{registrationId}");
        result.clientId(this.properties.getClientId());
        result.clientSecret(this.properties.getClientSecret());
        AADAuthorizationServerEndpoints endpoints = new AADAuthorizationServerEndpoints(this.properties.getBaseUri(), this.properties.getTenantId());
        result.authorizationUri(endpoints.authorizationEndpoint());
        result.tokenUri(endpoints.tokenEndpoint());
        result.jwkSetUri(endpoints.jwkSetEndpoint());
        LinkedHashMap<String, String> configurationMetadata = new LinkedHashMap<String, String>();
        String endSessionEndpoint = endpoints.endSessionEndpoint();
        configurationMetadata.put("end_session_endpoint", endSessionEndpoint);
        result.providerConfigurationMetadata(configurationMetadata);
        return result;
    }

    @Configuration
    @ConditionalOnBean(value={ObjectPostProcessor.class})
    @ConditionalOnMissingBean(value={WebSecurityConfigurerAdapter.class})
    public static class DefaultAADWebSecurityConfigurerAdapter
    extends AADWebSecurityConfigurerAdapter {
        @Override
        protected void configure(HttpSecurity http) throws Exception {
            super.configure(http);
        }
    }
}

