/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.webapp.AADOAuth2Error;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import java.io.IOException;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;

public class ConditionalAccessResponseErrorHandler
implements ResponseErrorHandler {
    private final OAuth2ErrorHttpMessageConverter oauth2ErrorConverter = new OAuth2ErrorHttpMessageConverter();
    private final ResponseErrorHandler defaultErrorHandler = new DefaultResponseErrorHandler();

    protected ConditionalAccessResponseErrorHandler() {
        this.oauth2ErrorConverter.setErrorConverter((Converter)new AADOAuth2ErrorConverter());
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return this.defaultErrorHandler.hasError(response);
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        OAuth2Error oauth2Error;
        if (!HttpStatus.BAD_REQUEST.equals((Object)response.getStatusCode())) {
            this.defaultErrorHandler.handleError(response);
        }
        if ((oauth2Error = this.readErrorFromWwwAuthenticate(response.getHeaders())) == null) {
            oauth2Error = (OAuth2Error)this.oauth2ErrorConverter.read(OAuth2Error.class, (HttpInputMessage)response);
        }
        throw new OAuth2AuthorizationException(oauth2Error);
    }

    private OAuth2Error readErrorFromWwwAuthenticate(HttpHeaders headers) {
        BearerTokenError bearerTokenError;
        String wwwAuthenticateHeader = headers.getFirst("WWW-Authenticate");
        if (!StringUtils.hasText((String)wwwAuthenticateHeader)) {
            return null;
        }
        try {
            bearerTokenError = BearerTokenError.parse((String)wwwAuthenticateHeader);
        }
        catch (Exception ex) {
            return null;
        }
        String errorCode = bearerTokenError.getCode() != null ? bearerTokenError.getCode() : "server_error";
        String errorDescription = bearerTokenError.getDescription();
        String errorUri = bearerTokenError.getURI() != null ? bearerTokenError.getURI().toString() : null;
        return new OAuth2Error(errorCode, errorDescription, errorUri);
    }

    private static class AADOAuth2ErrorConverter
    implements Converter<Map<String, String>, OAuth2Error> {
        private AADOAuth2ErrorConverter() {
        }

        public OAuth2Error convert(Map<String, String> parameters) {
            String errorCode = parameters.get("error");
            String description = parameters.get("error_description");
            String errorCodes = parameters.get("error_codes");
            String timestamp = parameters.get("timestamp");
            String traceId = parameters.get("trace_id");
            String correlationId = parameters.get("correlation_id");
            String uri = parameters.get("error_uri");
            String subError = parameters.get("suberror");
            String claims = parameters.get("claims");
            return new AADOAuth2Error(errorCode, description, errorCodes, timestamp, traceId, correlationId, uri, subError, claims);
        }
    }
}

