/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp.jackson;

import com.azure.spring.aad.webapp.jackson.AADJsonNodeUtil;
import com.azure.spring.aad.webapp.jackson.AADStdConverters;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.io.IOException;
import java.util.Collection;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

class AADClientRegistrationDeserializer
extends JsonDeserializer<ClientRegistration> {
    private static final StdConverter<JsonNode, ClientAuthenticationMethod> CLIENT_AUTHENTICATION_METHOD_CONVERTER = new AADStdConverters.ClientAuthenticationMethodConverter();
    private static final StdConverter<JsonNode, AuthorizationGrantType> AUTHORIZATION_GRANT_TYPE_CONVERTER = new AADStdConverters.AuthorizationGrantTypeConverter();
    private static final StdConverter<JsonNode, AuthenticationMethod> AUTHENTICATION_METHOD_CONVERTER = new AADStdConverters.AuthenticationMethodConverter();

    AADClientRegistrationDeserializer() {
    }

    public ClientRegistration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode clientRegistrationNode = (JsonNode)mapper.readTree(parser);
        JsonNode providerDetailsNode = AADJsonNodeUtil.findObjectNode(clientRegistrationNode, "providerDetails");
        JsonNode userInfoEndpointNode = AADJsonNodeUtil.findObjectNode(providerDetailsNode, "userInfoEndpoint");
        return ClientRegistration.withRegistrationId((String)AADJsonNodeUtil.findStringValue(clientRegistrationNode, "registrationId")).clientId(AADJsonNodeUtil.findStringValue(clientRegistrationNode, "clientId")).clientSecret(AADJsonNodeUtil.findStringValue(clientRegistrationNode, "clientSecret")).clientAuthenticationMethod((ClientAuthenticationMethod)CLIENT_AUTHENTICATION_METHOD_CONVERTER.convert((Object)AADJsonNodeUtil.findObjectNode(clientRegistrationNode, "clientAuthenticationMethod"))).authorizationGrantType((AuthorizationGrantType)AUTHORIZATION_GRANT_TYPE_CONVERTER.convert((Object)AADJsonNodeUtil.findObjectNode(clientRegistrationNode, "authorizationGrantType"))).redirectUriTemplate(AADJsonNodeUtil.findStringValue(clientRegistrationNode, "redirectUriTemplate")).scope((Collection)AADJsonNodeUtil.findValue(clientRegistrationNode, "scopes", AADJsonNodeUtil.SET_TYPE_REFERENCE, mapper)).clientName(AADJsonNodeUtil.findStringValue(clientRegistrationNode, "clientName")).authorizationUri(AADJsonNodeUtil.findStringValue(providerDetailsNode, "authorizationUri")).tokenUri(AADJsonNodeUtil.findStringValue(providerDetailsNode, "tokenUri")).userInfoUri(AADJsonNodeUtil.findStringValue(userInfoEndpointNode, "uri")).userInfoAuthenticationMethod((AuthenticationMethod)AUTHENTICATION_METHOD_CONVERTER.convert((Object)AADJsonNodeUtil.findObjectNode(userInfoEndpointNode, "authenticationMethod"))).userNameAttributeName(AADJsonNodeUtil.findStringValue(userInfoEndpointNode, "userNameAttributeName")).jwkSetUri(AADJsonNodeUtil.findStringValue(providerDetailsNode, "jwkSetUri")).providerConfigurationMetadata(AADJsonNodeUtil.findValue(providerDetailsNode, "configurationMetadata", AADJsonNodeUtil.MAP_TYPE_REFERENCE, mapper)).build();
    }
}

