/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.b2c;

import com.azure.spring.autoconfigure.b2c.AADB2CAuthorizationRequestResolver;
import com.azure.spring.autoconfigure.b2c.AADB2CClientRegistrationRepository;
import com.azure.spring.autoconfigure.b2c.AADB2CLogoutSuccessHandler;
import com.azure.spring.autoconfigure.b2c.AADB2COidcLoginConfigurer;
import com.azure.spring.autoconfigure.b2c.AADB2CProperties;
import com.azure.spring.autoconfigure.b2c.AADB2CURL;
import com.azure.spring.telemetry.TelemetryData;
import com.azure.spring.telemetry.TelemetrySender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnResource(resources={"classpath:aadb2c.enable.config"})
@ConditionalOnProperty(prefix="azure.activedirectory.b2c", value={"tenant", "client-id", "client-secret", "reply-url", "user-flows.sign-up-or-sign-in"})
@EnableConfigurationProperties(value={AADB2CProperties.class})
public class AADB2CAutoConfiguration {
    private final ClientRegistrationRepository repository;
    private final AADB2CProperties properties;

    public AADB2CAutoConfiguration(@NonNull ClientRegistrationRepository repository, @NonNull AADB2CProperties properties) {
        this.repository = repository;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public AADB2CAuthorizationRequestResolver b2cOAuth2AuthorizationRequestResolver() {
        return new AADB2CAuthorizationRequestResolver(this.repository, this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AADB2CLogoutSuccessHandler b2cLogoutSuccessHandler() {
        return new AADB2CLogoutSuccessHandler(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AADB2COidcLoginConfigurer b2cLoginConfigurer(AADB2CLogoutSuccessHandler handler, AADB2CAuthorizationRequestResolver resolver) {
        return new AADB2COidcLoginConfigurer(this.properties, handler, resolver);
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.properties.isAllowTelemetry()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(AADB2CAutoConfiguration.class));
            events.put("tenantName", this.properties.getTenant());
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }

    @Configuration
    @ConditionalOnResource(resources={"classpath:aadb2c.enable.config"})
    @ConditionalOnProperty(prefix="azure.activedirectory.b2c", value={"oidc-enabled"}, havingValue="true", matchIfMissing=true)
    public static class AADB2COidcAutoConfiguration {
        private final AADB2CProperties properties;

        public AADB2COidcAutoConfiguration(@NonNull AADB2CProperties properties) {
            this.properties = properties;
        }

        private void addB2CClientRegistration(@NonNull List<ClientRegistration> registrations, String userFlow) {
            if (StringUtils.hasText((String)userFlow)) {
                registrations.add(this.b2cClientRegistration(userFlow));
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public ClientRegistrationRepository clientRegistrationRepository() {
            ArrayList<ClientRegistration> signUpOrSignInRegistrations = new ArrayList<ClientRegistration>(1);
            ArrayList<ClientRegistration> otherRegistrations = new ArrayList<ClientRegistration>();
            this.addB2CClientRegistration(signUpOrSignInRegistrations, this.properties.getUserFlows().getSignUpOrSignIn());
            this.addB2CClientRegistration(otherRegistrations, this.properties.getUserFlows().getProfileEdit());
            this.addB2CClientRegistration(otherRegistrations, this.properties.getUserFlows().getPasswordReset());
            return new AADB2CClientRegistrationRepository(signUpOrSignInRegistrations, otherRegistrations);
        }

        private ClientRegistration b2cClientRegistration(String userFlow) {
            Assert.hasText((String)userFlow, (String)"User flow should contains text.");
            return ClientRegistration.withRegistrationId((String)userFlow).clientId(this.properties.getClientId()).clientSecret(this.properties.getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUriTemplate(this.properties.getReplyUrl()).scope(new String[]{this.properties.getClientId(), "openid"}).authorizationUri(AADB2CURL.getAuthorizationUrl(this.properties.getTenant())).tokenUri(AADB2CURL.getTokenUrl(this.properties.getTenant(), userFlow)).jwkSetUri(AADB2CURL.getJwkSetUrl(this.properties.getTenant(), userFlow)).userNameAttributeName(this.properties.getUserNameAttributeName()).clientName(userFlow).build();
        }
    }
}

