/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad;

import com.azure.spring.aad.AADApplicationType;
import com.azure.spring.aad.AADAuthorizationGrantType;
import com.azure.spring.aad.AADAuthorizationServerEndpoints;
import com.azure.spring.aad.webapp.AuthorizationClientProperties;
import com.azure.spring.aad.webapp.AzureClientRegistration;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.Assert;

public class AADClientRegistrationRepository
implements ClientRegistrationRepository,
Iterable<ClientRegistration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADClientRegistrationRepository.class);
    public static final String AZURE_CLIENT_REGISTRATION_ID = "azure";
    protected final AzureClientRegistration azureClient;
    protected final Map<String, ClientRegistration> delegatedClients;
    protected final Map<String, ClientRegistration> allClients;
    protected final AADAuthenticationProperties properties;

    public AADClientRegistrationRepository(AADAuthenticationProperties properties) {
        this.properties = properties;
        this.azureClient = this.azureClientRegistration();
        this.delegatedClients = this.delegatedClientRegistrations();
        this.allClients = this.allClientRegistrations();
    }

    private AzureClientRegistration azureClientRegistration() {
        if (!this.needDelegation()) {
            return null;
        }
        AuthorizationClientProperties azureProperties = this.properties.getAuthorizationClients().getOrDefault(AZURE_CLIENT_REGISTRATION_ID, this.defaultAzureAuthorizationClientProperties());
        ClientRegistration.Builder builder = this.toClientRegistrationBuilder(AZURE_CLIENT_REGISTRATION_ID, azureProperties);
        Set<String> authorizationCodeScopes = this.azureClientAuthorizationCodeScopes();
        ClientRegistration client = builder.scope(authorizationCodeScopes).build();
        Set<String> accessTokenScopes = this.azureClientAccessTokenScopes();
        if (AADClientRegistrationRepository.resourceServerCount(accessTokenScopes) == 0 && AADClientRegistrationRepository.resourceServerCount(authorizationCodeScopes) > 1) {
            accessTokenScopes.add(this.properties.getGraphBaseUri() + "User.Read");
        }
        return new AzureClientRegistration(client, accessTokenScopes);
    }

    private boolean needDelegation() {
        return AADApplicationType.WEB_APPLICATION == this.properties.getApplicationType() || AADApplicationType.WEB_APPLICATION_AND_RESOURCE_SERVER == this.properties.getApplicationType();
    }

    private Map<String, ClientRegistration> delegatedClientRegistrations() {
        if (!this.needDelegation()) {
            return Collections.emptyMap();
        }
        return this.properties.getAuthorizationClients().entrySet().stream().filter(entry -> this.isAzureDelegatedClientRegistration((String)entry.getKey(), (AuthorizationClientProperties)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toClientRegistration((String)entry.getKey(), (AuthorizationClientProperties)entry.getValue())));
    }

    private Map<String, ClientRegistration> allClientRegistrations() {
        Map<String, ClientRegistration> result = this.properties.getAuthorizationClients().entrySet().stream().filter(entry -> !this.delegatedClients.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toClientRegistration((String)entry.getKey(), (AuthorizationClientProperties)entry.getValue())));
        if (this.needDelegation()) {
            result.putAll(this.delegatedClients);
            result.put(AZURE_CLIENT_REGISTRATION_ID, this.azureClient.getClient());
        }
        return Collections.unmodifiableMap(result);
    }

    private ClientRegistration.Builder toClientRegistrationBuilder(String registrationId, AuthorizationClientProperties clientProperties) {
        AuthorizationGrantType authorizationGrantType;
        AADAuthorizationServerEndpoints endpoints = new AADAuthorizationServerEndpoints(this.properties.getBaseUri(), this.properties.getTenantId());
        switch (clientProperties.getAuthorizationGrantType()) {
            case AUTHORIZATION_CODE: {
                authorizationGrantType = AuthorizationGrantType.AUTHORIZATION_CODE;
                break;
            }
            case ON_BEHALF_OF: {
                authorizationGrantType = new AuthorizationGrantType(AADAuthorizationGrantType.ON_BEHALF_OF.getValue());
                break;
            }
            case CLIENT_CREDENTIALS: {
                authorizationGrantType = AuthorizationGrantType.CLIENT_CREDENTIALS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authorization type " + clientProperties.getAuthorizationGrantType().getValue());
            }
        }
        return ClientRegistration.withRegistrationId((String)registrationId).clientName(registrationId).authorizationGrantType(authorizationGrantType).scope(this.toScopes(clientProperties)).redirectUri(this.properties.getRedirectUriTemplate()).userNameAttributeName(this.properties.getUserNameAttribute()).clientId(this.properties.getClientId()).clientSecret(this.properties.getClientSecret()).authorizationUri(endpoints.authorizationEndpoint()).tokenUri(endpoints.tokenEndpoint()).jwkSetUri(endpoints.jwkSetEndpoint()).providerConfigurationMetadata(this.providerConfigurationMetadata(endpoints));
    }

    private AuthorizationClientProperties defaultAzureAuthorizationClientProperties() {
        AuthorizationClientProperties result = new AuthorizationClientProperties();
        result.setAuthorizationGrantType(AADAuthorizationGrantType.AUTHORIZATION_CODE);
        return result;
    }

    private List<String> toScopes(AuthorizationClientProperties clientProperties) {
        List<String> result = clientProperties.getScopes();
        if (clientProperties.isOnDemand()) {
            if (!result.contains("openid")) {
                result.add("openid");
            }
            if (!result.contains("profile")) {
                result.add("profile");
            }
        }
        return result;
    }

    private Map<String, Object> providerConfigurationMetadata(AADAuthorizationServerEndpoints endpoints) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String endSessionEndpoint = endpoints.endSessionEndpoint();
        result.put("end_session_endpoint", endSessionEndpoint);
        return result;
    }

    public static int resourceServerCount(Set<String> scopes) {
        return (int)scopes.stream().filter(scope -> scope.contains("/")).map(scope -> scope.substring(0, scope.lastIndexOf(47))).distinct().count();
    }

    private Set<String> azureClientAuthorizationCodeScopes() {
        Set<String> result = this.azureClientAccessTokenScopes();
        result.addAll(this.delegatedClientsAccessTokenScopes());
        return result;
    }

    private Set<String> delegatedClientsAccessTokenScopes() {
        return this.properties.getAuthorizationClients().values().stream().filter(p -> !p.isOnDemand() && AADAuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)p.getAuthorizationGrantType())).flatMap(p -> p.getScopes().stream()).collect(Collectors.toSet());
    }

    private Set<String> azureClientAccessTokenScopes() {
        Set<String> result = Optional.of(this.properties).map(AADAuthenticationProperties::getAuthorizationClients).map(clients -> (AuthorizationClientProperties)clients.get(AZURE_CLIENT_REGISTRATION_ID)).map(AuthorizationClientProperties::getScopes).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
        result.addAll(this.azureClientOpenidScopes());
        if (this.properties.allowedGroupIdsConfigured() || this.properties.allowedGroupNamesConfigured()) {
            result.add(this.properties.getGraphBaseUri() + "User.Read");
            result.add(this.properties.getGraphBaseUri() + "Directory.Read.All");
        }
        return result;
    }

    private Set<String> azureClientOpenidScopes() {
        HashSet<String> result = new HashSet<String>();
        result.add("openid");
        result.add("profile");
        if (!this.properties.getAuthorizationClients().isEmpty()) {
            result.add("offline_access");
        }
        return result;
    }

    private ClientRegistration toClientRegistration(String registrationId, AuthorizationClientProperties clientProperties) {
        return this.toClientRegistrationBuilder(registrationId, clientProperties).build();
    }

    private boolean isAzureDelegatedClientRegistration(String registrationId, AuthorizationClientProperties clientProperties) {
        return !AZURE_CLIENT_REGISTRATION_ID.equals(registrationId) && AADAuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientProperties.getAuthorizationGrantType()) && !clientProperties.isOnDemand();
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return this.allClients.get(registrationId);
    }

    @Override
    public Iterator<ClientRegistration> iterator() {
        if (!this.needDelegation()) {
            return this.allClients.values().iterator();
        }
        return Collections.singleton(this.azureClient.getClient()).iterator();
    }

    public AzureClientRegistration getAzureClient() {
        return this.azureClient;
    }

    public boolean isAzureDelegatedClientRegistration(ClientRegistration client) {
        return this.delegatedClients.containsValue(client);
    }

    public boolean isAzureDelegatedClientRegistration(String registrationId) {
        return this.delegatedClients.containsKey(registrationId);
    }

    public static boolean isDefaultClient(String registrationId) {
        return AZURE_CLIENT_REGISTRATION_ID.equals(registrationId);
    }
}

