/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator;

import com.baidu.unbiz.fluentvalidator.AnnotationValidator;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.annotation.FluentValid;
import com.baidu.unbiz.fluentvalidator.annotation.FluentValidate;
import com.baidu.unbiz.fluentvalidator.registry.Registry;
import com.baidu.unbiz.fluentvalidator.util.CollectionUtil;
import com.baidu.unbiz.fluentvalidator.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationValidatorCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationValidatorCache.class);
    private static ConcurrentHashMap<Class<?>, List<AnnotationValidator>> CLASS_2_ANNOTATION_VALIDATOR_MAP = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<? extends Validator>, Validator> VALIDATOR_MAP = new ConcurrentHashMap();

    public static List<AnnotationValidator> getAnnotationValidator(Registry registry, Object object) {
        if (registry == null || object == null) {
            return Collections.emptyList();
        }
        Class<?> clazz = object.getClass();
        if (!CLASS_2_ANNOTATION_VALIDATOR_MAP.containsKey(clazz)) {
            AnnotationValidatorCache.addByClass(registry, object.getClass());
        }
        return CLASS_2_ANNOTATION_VALIDATOR_MAP.get(clazz);
    }

    private static void addByClass(Registry registry, Class<?> clazz) {
        try {
            if (CLASS_2_ANNOTATION_VALIDATOR_MAP.contains(clazz)) {
                return;
            }
            List<AnnotationValidator> annotationValidators = AnnotationValidatorCache.getAllAnnotationValidators(registry, clazz);
            if (CollectionUtil.isEmpty(annotationValidators)) {
                LOGGER.warn(String.format("Annotation-based validation enabled for %s, and to-do validators are empty", clazz.getSimpleName()));
            } else {
                CLASS_2_ANNOTATION_VALIDATOR_MAP.putIfAbsent(clazz, annotationValidators);
                LOGGER.debug(String.format("Annotation-based validation added for %s, and to-do validators are %s", clazz.getSimpleName(), annotationValidators));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to add annotation validators " + e.getMessage(), (Throwable)e);
        }
    }

    private static List<AnnotationValidator> getAllAnnotationValidators(Registry registry, Class<?> clazz) {
        Field field;
        int i;
        ArrayList<AnnotationValidator> annotationValidators = CollectionUtil.createArrayList();
        Field[] fields = ReflectionUtil.getAnnotationFields(clazz, FluentValidate.class);
        for (i = 0; i < fields.length; ++i) {
            field = fields[i];
            FluentValidate fluentValidateAnnt = ReflectionUtil.getAnnotation(field, FluentValidate.class);
            Class<? extends Validator>[] validatorClasses = fluentValidateAnnt.value();
            Class<?>[] groups = fluentValidateAnnt.groups();
            if (validatorClasses == null || validatorClasses.length == 0) {
                LOGGER.warn(String.format("No validator annotation bound %s#%s", clazz.getSimpleName(), field.getName()));
                continue;
            }
            ArrayList<Validator> validators = CollectionUtil.createArrayList(4);
            for (Class<? extends Validator> validatorClass : validatorClasses) {
                if (!Validator.class.isAssignableFrom(validatorClass)) {
                    LOGGER.warn(String.format("Validator annotation class %s is not assignable from %s", validatorClass.getSimpleName(), Validator.class.getSimpleName()));
                    continue;
                }
                if (VALIDATOR_MAP.containsKey(validatorClass)) continue;
                List<? extends Validator> validatorsFound = registry.findByType(validatorClass);
                if (CollectionUtil.isEmpty(validatorsFound)) {
                    LOGGER.warn(String.format("Validator annotation class %s not found or init failed for %s#%s", validatorClass.getSimpleName(), clazz.getSimpleName(), field.getName()));
                    continue;
                }
                if (validatorsFound.size() > 1) {
                    LOGGER.warn(String.format("Validator annotation class %s found multiple instances for %s#%s, so the first one will be used", validatorClass.getSimpleName(), clazz.getSimpleName(), field.getName()));
                }
                VALIDATOR_MAP.putIfAbsent(validatorClass, validatorsFound.get(0));
                validators.add(VALIDATOR_MAP.get(validatorClass));
                LOGGER.info(String.format("Cached validator %s", validatorClass.getSimpleName()));
            }
            if (CollectionUtil.isEmpty(validators)) {
                LOGGER.warn(String.format("Annotation-based validation enabled but none of the validators is applicable for %s#%s", clazz.getSimpleName(), field.getName()));
                continue;
            }
            AnnotationValidator av = new AnnotationValidator();
            av.setField(field);
            av.setMethod(ReflectionUtil.getGetterMethod(clazz, field));
            av.setValidators(validators);
            av.setGroups(groups);
            annotationValidators.add(av);
            LOGGER.trace("Annotation-based validation added " + av);
        }
        fields = ReflectionUtil.getAnnotationFields(clazz, FluentValid.class);
        for (i = 0; i < fields.length; ++i) {
            field = fields[i];
            FluentValid cascadeAnnt = ReflectionUtil.getAnnotation(field, FluentValid.class);
            AnnotationValidator av = new AnnotationValidator();
            av.setField(field);
            av.setMethod(ReflectionUtil.getGetterMethod(clazz, field));
            av.setValidators(null);
            av.setGroups(null);
            av.setIsCascade(cascadeAnnt != null);
            annotationValidators.add(av);
            LOGGER.trace("Cascade annotation-based validation added " + av);
        }
        return annotationValidators;
    }
}

