/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator.support;

import com.baidu.unbiz.fluentvalidator.support.Computable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class ConcurrentCache<K, V>
implements Computable<K, V> {
    protected final ConcurrentMap<K, Future<V>> concurrentMap = new ConcurrentHashMap<K, Future<V>>();

    public static <K, V> Computable<K, V> createComputable() {
        return new ConcurrentCache<K, V>();
    }

    @Override
    public V get(K key, Callable<V> callable) {
        FutureTask<V> futureTask;
        FutureTask<V> future = (FutureTask<V>)this.concurrentMap.get(key);
        if (future == null && (future = (Future)this.concurrentMap.putIfAbsent(key, futureTask = new FutureTask<V>(callable))) == null) {
            future = futureTask;
            futureTask.run();
        }
        try {
            return future.get();
        }
        catch (Exception e) {
            this.concurrentMap.remove(key);
            return null;
        }
    }
}

