/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator;

import com.baidu.unbiz.fluentvalidator.ComplexResult;
import com.baidu.unbiz.fluentvalidator.ComplexResult2;
import com.baidu.unbiz.fluentvalidator.Result;
import com.baidu.unbiz.fluentvalidator.ResultCollector;
import com.baidu.unbiz.fluentvalidator.ValidationError;
import com.baidu.unbiz.fluentvalidator.ValidationResult;
import com.baidu.unbiz.fluentvalidator.util.CollectionUtil;
import com.baidu.unbiz.fluentvalidator.util.Function;
import com.baidu.unbiz.fluentvalidator.util.Supplier;

public class ResultCollectors {
    static <T extends ComplexResult> T newComplexResult(Supplier<T> supplier, ValidationResult result) {
        ComplexResult ret = (ComplexResult)supplier.get();
        if (result.isSuccess()) {
            ret.setIsSuccess(true);
        } else {
            ret.setIsSuccess(false);
            ret.setErrors(result.getErrors());
        }
        ret.setTimeElapsed(result.getTimeElapsed());
        return (T)ret;
    }

    public static ResultCollector<Result> toSimple() {
        return new SimpleResultCollectorImpl();
    }

    public static ResultCollector<ComplexResult> toComplex() {
        return new ComplexResultCollectorImpl();
    }

    public static ResultCollector<ComplexResult2> toComplex2() {
        return new ComplexResult2CollectorImpl();
    }

    static class ComplexResult2CollectorImpl
    implements ResultCollector<ComplexResult2> {
        ComplexResult2CollectorImpl() {
        }

        @Override
        public ComplexResult2 toResult(ValidationResult result) {
            return ResultCollectors.newComplexResult(new Supplier<ComplexResult2>(){

                @Override
                public ComplexResult2 get() {
                    return new ComplexResult2();
                }
            }, result);
        }
    }

    static class ComplexResultCollectorImpl
    implements ResultCollector<ComplexResult> {
        ComplexResultCollectorImpl() {
        }

        @Override
        public ComplexResult toResult(ValidationResult result) {
            return ResultCollectors.newComplexResult(new Supplier<ComplexResult>(){

                @Override
                public ComplexResult get() {
                    return new ComplexResult();
                }
            }, result);
        }
    }

    static class SimpleResultCollectorImpl
    implements ResultCollector<Result> {
        SimpleResultCollectorImpl() {
        }

        @Override
        public Result toResult(ValidationResult result) {
            Result ret = new Result();
            if (result.isSuccess()) {
                ret.setIsSuccess(true);
            } else {
                ret.setIsSuccess(false);
                ret.setErrors(CollectionUtil.transform(result.getErrors(), new Function<ValidationError, String>(){

                    @Override
                    public String apply(ValidationError input) {
                        return input.getErrorMsg();
                    }
                }));
            }
            return ret;
        }
    }
}

