/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator.util;

import com.baidu.unbiz.fluentvalidator.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class CollectionUtil {
    public static <E> ArrayList<E> createArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> createArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <E> LinkedList<E> createLinkedList() {
        return new LinkedList();
    }

    public static <K, V> HashMap<K, V> createHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public static <F, T> List<T> transform(Collection<F> fromList, Function<? super F, ? extends T> function) {
        if (CollectionUtil.isEmpty(fromList)) {
            return Collections.emptyList();
        }
        ArrayList<T> ret = new ArrayList<T>(fromList.size());
        for (F f : fromList) {
            T t = function.apply(f);
            if (t == null) continue;
            ret.add(t);
        }
        return ret;
    }
}

